/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.sosy_lab.java_smt.api.SolverException;

class Mathsat5NativeApi {
    private static final int MSAT_UNKNOWN = -1;
    private static final int MSAT_UNSAT = 0;
    private static final int MSAT_SAT = 1;
    public static final int MSAT_UNDEF = -1;
    public static final int MSAT_FALSE = 0;
    public static final int MSAT_TRUE = 1;
    public static final int MSAT_OPTIMUM = 0;
    public static final int MSAT_INITIAL_LOWER = 1;
    public static final int MSAT_INITIAL_UPPER = 2;
    public static final int MSAT_FINAL_LOWER = 3;
    public static final int MSAT_FINAL_UPPER = 4;
    public static final int MSAT_FINAL_ERROR = 5;
    public static final int MSAT_OBJECTIVE_MINIMIZE = -1;
    public static final int MSAT_OBJECTIVE_MAXIMIZE = 1;
    public static final int MSAT_TAG_ERROR = -1;
    public static final int MSAT_TAG_UNKNOWN = 0;
    public static final int MSAT_TAG_TRUE = 1;
    public static final int MSAT_TAG_FALSE = 2;
    public static final int MSAT_TAG_AND = 3;
    public static final int MSAT_TAG_OR = 4;
    public static final int MSAT_TAG_NOT = 5;
    public static final int MSAT_TAG_IFF = 6;
    public static final int MSAT_TAG_PLUS = 7;
    public static final int MSAT_TAG_TIMES = 8;
    public static final int MSAT_TAG_FLOOR = 9;
    public static final int MSAT_TAG_LEQ = 10;
    public static final int MSAT_TAG_EQ = 11;
    public static final int MSAT_TAG_ITE = 12;
    public static final int MSAT_TAG_INT_MOD_CONGR = 13;
    public static final int MSAT_TAG_BV_CONCAT = 14;
    public static final int MSAT_TAG_BV_EXTRACT = 15;
    public static final int MSAT_TAG_BV_NOT = 16;
    public static final int MSAT_TAG_BV_AND = 17;
    public static final int MSAT_TAG_BV_OR = 18;
    public static final int MSAT_TAG_BV_XOR = 19;
    public static final int MSAT_TAG_BV_ULT = 20;
    public static final int MSAT_TAG_BV_SLT = 21;
    public static final int MSAT_TAG_BV_ULE = 22;
    public static final int MSAT_TAG_BV_SLE = 23;
    public static final int MSAT_TAG_BV_COMP = 24;
    public static final int MSAT_TAG_BV_NEG = 25;
    public static final int MSAT_TAG_BV_ADD = 26;
    public static final int MSAT_TAG_BV_SUB = 27;
    public static final int MSAT_TAG_BV_MUL = 28;
    public static final int MSAT_TAG_BV_UDIV = 29;
    public static final int MSAT_TAG_BV_SDIV = 30;
    public static final int MSAT_TAG_BV_UREM = 31;
    public static final int MSAT_TAG_BV_SREM = 32;
    public static final int MSAT_TAG_BV_LSHL = 33;
    public static final int MSAT_TAG_BV_LSHR = 34;
    public static final int MSAT_TAG_BV_ASHR = 35;
    public static final int MSAT_TAG_BV_ROL = 36;
    public static final int MSAT_TAG_BV_ROR = 37;
    public static final int MSAT_TAG_BV_ZEXT = 38;
    public static final int MSAT_TAG_BV_SEXT = 39;
    public static final int MSAT_TAG_ARRAY_READ = 40;
    public static final int MSAT_TAG_ARRAY_WRITE = 41;
    public static final int MSAT_TAG_ARRAY_CONST = 42;
    public static final int MSAT_TAG_FP_EQ = 43;
    public static final int MSAT_TAG_FP_LT = 44;
    public static final int MSAT_TAG_FP_LE = 45;
    public static final int MSAT_TAG_FP_NEG = 46;
    public static final int MSAT_TAG_FP_ADD = 47;
    public static final int MSAT_TAG_FP_SUB = 48;
    public static final int MSAT_TAG_FP_MUL = 49;
    public static final int MSAT_TAG_FP_DIV = 50;
    public static final int MSAT_TAG_FP_SQRT = 51;
    public static final int MSAT_TAG_FP_ABS = 52;
    public static final int MSAT_TAG_FP_MIN = 53;
    public static final int MSAT_TAG_FP_MAX = 54;
    public static final int MSAT_TAG_FP_CAST = 55;
    public static final int MSAT_TAG_FP_ROUND_TO_INT = 56;
    public static final int MSAT_TAG_FP_FROM_SBV = 57;
    public static final int MSAT_TAG_FP_FROM_UBV = 58;
    public static final int MSAT_TAG_FP_TO_BV = 59;
    public static final int MSAT_TAG_FP_AS_IEEEBV = 60;
    public static final int MSAT_TAG_FP_ISNAN = 61;
    public static final int MSAT_TAG_FP_ISINF = 62;
    public static final int MSAT_TAG_FP_ISZERO = 63;
    public static final int MSAT_TAG_FP_ISSUBNORMAL = 64;
    public static final int MSAT_TAG_FP_ISNORMAL = 65;
    public static final int MSAT_TAG_FP_ISNEG = 66;
    public static final int MSAT_TAG_FP_ISPOS = 67;
    public static final int MSAT_TAG_FP_FROM_IEEEBV = 68;
    public static final int MSAT_TAG_INT_FROM_UBV = 69;
    public static final int MSAT_TAG_INT_FROM_SBV = 70;
    public static final int MSAT_TAG_INT_TO_BV = 71;
    private static final ImmutableSet<String> ALLOWED_SOLVE_FAILURE_MESSAGES = ImmutableSet.of((Object)"unsupported", (Object)"non-integer model value", (Object)"build_model: too many iterations", (Object)"FP<->BV combination unsupported by the current configuration");

    private Mathsat5NativeApi() {
    }

    public static int msat_all_sat(long e, long[] important, AllSatModelCallback func) throws InterruptedException {
        return Mathsat5NativeApi.msat_all_sat(e, important, important.length, func);
    }

    public static boolean msat_check_sat(long e) throws InterruptedException, IllegalStateException, SolverException {
        return Mathsat5NativeApi.processSolveResult(e, Mathsat5NativeApi.msat_solve(e));
    }

    public static boolean msat_check_sat_with_assumptions(long e, long[] assumptions) throws InterruptedException, IllegalStateException, SolverException {
        return Mathsat5NativeApi.processSolveResult(e, Mathsat5NativeApi.msat_solve_with_assumptions(e, assumptions, assumptions.length));
    }

    private static boolean processSolveResult(long e, int resultCode) throws IllegalStateException, SolverException {
        switch (resultCode) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        String msg = Strings.emptyToNull((String)Mathsat5NativeApi.msat_last_error_message(e));
        if (ALLOWED_SOLVE_FAILURE_MESSAGES.contains((Object)msg)) {
            throw new SolverException(msg);
        }
        String code = resultCode == -1 ? "\"unknown\"" : resultCode + "";
        throw new IllegalStateException("msat_solve returned " + code + (msg != null ? ": " + msg : ""));
    }

    public static long msat_get_interpolant(long e, int[] groups_of_a) {
        return Mathsat5NativeApi.msat_get_interpolant(e, groups_of_a, groups_of_a.length);
    }

    public static native long msat_create_config();

    public static native void msat_destroy_config(long var0);

    public static native long msat_create_env(long var0);

    public static native long msat_create_shared_env(long var0, long var2);

    public static native void msat_destroy_env(long var0);

    @CheckReturnValue
    private static native int msat_set_option(long var0, String var2, String var3);

    public static void msat_set_option_checked(long cfg, String option, String value) throws IllegalArgumentException {
        int retval = Mathsat5NativeApi.msat_set_option(cfg, option, value);
        if (retval != 0) {
            throw new IllegalArgumentException("Could not set Mathsat option \"" + option + "=" + value + "\", error code " + retval);
        }
    }

    public static native long msat_get_bool_type(long var0);

    public static native long msat_get_rational_type(long var0);

    public static native long msat_get_integer_type(long var0);

    public static native long msat_get_bv_type(long var0, int var2);

    public static native long msat_get_array_type(long var0, long var2, long var4);

    public static native long msat_get_array_index_type(long var0, long var2);

    public static native long msat_get_array_element_type(long var0, long var2);

    public static native long msat_get_fp_type(long var0, int var2, int var3);

    public static native long msat_get_fp_roundingmode_type(long var0);

    public static native long msat_get_simple_type(long var0, String var2);

    public static native long msat_get_function_type(long var0, long[] var2, int var3, long var4);

    public static native boolean msat_is_bool_type(long var0, long var2);

    public static native boolean msat_is_rational_type(long var0, long var2);

    public static native boolean msat_is_integer_type(long var0, long var2);

    public static native boolean msat_is_bv_type(long var0, long var2);

    public static native int msat_get_bv_type_size(long var0, long var2);

    public static native boolean msat_is_array_type(long var0, long var2);

    public static native boolean msat_is_fp_type(long var0, long var2);

    public static native int msat_get_fp_type_exp_width(long var0, long var2);

    public static native int msat_get_fp_type_mant_width(long var0, long var2);

    public static native boolean msat_is_fp_roundingmode_type(long var0, long var2);

    public static native boolean msat_type_equals(long var0, long var2);

    public static native String msat_type_repr(long var0);

    public static native long msat_declare_function(long var0, String var2, long var3);

    public static native long msat_make_true(long var0);

    public static native long msat_make_false(long var0);

    public static native long msat_make_iff(long var0, long var2, long var4);

    public static native long msat_make_or(long var0, long var2, long var4);

    public static native long msat_make_and(long var0, long var2, long var4);

    public static native long msat_make_not(long var0, long var2);

    public static native long msat_make_equal(long var0, long var2, long var4);

    public static native long msat_make_leq(long var0, long var2, long var4);

    public static native long msat_make_plus(long var0, long var2, long var4);

    public static native long msat_make_times(long var0, long var2, long var4);

    public static native long msat_make_floor(long var0, long var2);

    public static native long msat_make_number(long var0, String var2);

    public static native long msat_make_int_modular_congruence(long var0, long var2, long var4, long var6);

    public static native long msat_make_term_ite(long var0, long var2, long var4, long var6);

    public static native long msat_make_constant(long var0, long var2);

    public static native long msat_make_uf(long var0, long var2, long[] var4);

    public static native long msat_make_array_read(long var0, long var2, long var4);

    public static native long msat_make_array_write(long var0, long var2, long var4, long var6);

    public static native long msat_make_array_const(long var0, long var2, long var4);

    public static native long msat_make_int_to_bv(long var0, int var2, long var3);

    public static native long msat_make_int_from_ubv(long var0, long var2);

    public static native long msat_make_int_from_sbv(long var0, long var2);

    public static native long msat_make_bv_number(long var0, String var2, int var3, int var4);

    public static native long msat_make_bv_concat(long var0, long var2, long var4);

    public static native long msat_make_bv_extract(long var0, int var2, int var3, long var4);

    public static native long msat_make_bv_or(long var0, long var2, long var4);

    public static native long msat_make_bv_xor(long var0, long var2, long var4);

    public static native long msat_make_bv_and(long var0, long var2, long var4);

    public static native long msat_make_bv_not(long var0, long var2);

    public static native long msat_make_bv_lshl(long var0, long var2, long var4);

    public static native long msat_make_bv_lshr(long var0, long var2, long var4);

    public static native long msat_make_bv_ashr(long var0, long var2, long var4);

    public static native long msat_make_bv_zext(long var0, int var2, long var3);

    public static native long msat_make_bv_sext(long var0, int var2, long var3);

    public static native long msat_make_bv_plus(long var0, long var2, long var4);

    public static native long msat_make_bv_minus(long var0, long var2, long var4);

    public static native long msat_make_bv_neg(long var0, long var2);

    public static native long msat_make_bv_times(long var0, long var2, long var4);

    public static native long msat_make_bv_udiv(long var0, long var2, long var4);

    public static native long msat_make_bv_urem(long var0, long var2, long var4);

    public static native long msat_make_bv_sdiv(long var0, long var2, long var4);

    public static native long msat_make_bv_srem(long var0, long var2, long var4);

    public static native long msat_make_bv_ult(long var0, long var2, long var4);

    public static native long msat_make_bv_uleq(long var0, long var2, long var4);

    public static native long msat_make_bv_slt(long var0, long var2, long var4);

    public static native long msat_make_bv_sleq(long var0, long var2, long var4);

    public static native long msat_make_bv_rol(long var0, int var2, long var3);

    public static native long msat_make_bv_ror(long var0, int var2, long var3);

    public static native long msat_make_bv_comp(long var0, long var2, long var4);

    public static native long msat_make_fp_roundingmode_nearest_even(long var0);

    public static native long msat_make_fp_roundingmode_zero(long var0);

    public static native long msat_make_fp_roundingmode_plus_inf(long var0);

    public static native long msat_make_fp_roundingmode_minus_inf(long var0);

    public static native long msat_make_fp_equal(long var0, long var2, long var4);

    public static native long msat_make_fp_lt(long var0, long var2, long var4);

    public static native long msat_make_fp_leq(long var0, long var2, long var4);

    public static native long msat_make_fp_neg(long var0, long var2);

    public static native long msat_make_fp_plus(long var0, long var2, long var4, long var6);

    public static native long msat_make_fp_minus(long var0, long var2, long var4, long var6);

    public static native long msat_make_fp_times(long var0, long var2, long var4, long var6);

    public static native long msat_make_fp_div(long var0, long var2, long var4, long var6);

    public static native long msat_make_fp_sqrt(long var0, long var2, long var4);

    public static native long msat_make_fp_abs(long var0, long var2);

    public static native long msat_make_fp_max(long var0, long var2, long var4);

    public static native long msat_make_fp_min(long var0, long var2, long var4);

    public static native long msat_make_fp_round_to_int(long var0, long var2, long var4);

    public static native long msat_make_fp_cast(long var0, long var2, long var4, long var6, long var8);

    public static native long msat_make_fp_to_bv(long var0, long var2, long var4, long var6);

    public static native long msat_make_fp_from_sbv(long var0, long var2, long var4, long var6, long var8);

    public static native long msat_make_fp_from_ubv(long var0, long var2, long var4, long var6, long var8);

    public static native long msat_make_fp_as_ieeebv(long var0, long var2);

    public static native long msat_make_fp_from_ieeebv(long var0, long var2, long var4, long var6);

    public static native long msat_make_fp_isnan(long var0, long var2);

    public static native long msat_make_fp_isinf(long var0, long var2);

    public static native long msat_make_fp_iszero(long var0, long var2);

    public static native long msat_make_fp_issubnormal(long var0, long var2);

    public static native long msat_make_fp_isnormal(long var0, long var2);

    public static native long msat_make_fp_isneg(long var0, long var2);

    public static native long msat_make_fp_ispos(long var0, long var2);

    public static native long msat_make_fp_plus_inf(long var0, long var2, long var4);

    public static native long msat_make_fp_minus_inf(long var0, long var2, long var4);

    public static native long msat_make_fp_nan(long var0, long var2, long var4);

    public static native long msat_make_fp_rat_number(long var0, String var2, long var3, long var5, long var7);

    public static native long msat_make_fp_bits_number(long var0, String var2, long var3, long var5);

    public static native long msat_make_term(long var0, long var2, long[] var4);

    public static native long msat_make_copy_from(long var0, long var2, long var4);

    public static native long msat_apply_substitution(long var0, long var2, int var4, long[] var5, long[] var6);

    public static native int msat_term_id(long var0);

    public static native int msat_term_arity(long var0);

    public static native long msat_term_get_arg(long var0, int var2);

    public static native long msat_term_get_type(long var0);

    public static native boolean msat_term_is_true(long var0, long var2);

    public static native boolean msat_term_is_false(long var0, long var2);

    public static native boolean msat_term_is_boolean_constant(long var0, long var2);

    public static native boolean msat_term_is_atom(long var0, long var2);

    public static native boolean msat_term_is_number(long var0, long var2);

    public static native boolean msat_term_is_and(long var0, long var2);

    public static native boolean msat_term_is_or(long var0, long var2);

    public static native boolean msat_term_is_not(long var0, long var2);

    public static native boolean msat_term_is_iff(long var0, long var2);

    public static native boolean msat_term_is_term_ite(long var0, long var2);

    public static native boolean msat_term_is_constant(long var0, long var2);

    public static native boolean msat_term_is_uf(long var0, long var2);

    public static native boolean msat_term_is_equal(long var0, long var2);

    public static native boolean msat_term_is_leq(long var0, long var2);

    public static native boolean msat_term_is_plus(long var0, long var2);

    public static native boolean msat_term_is_times(long var0, long var2);

    public static native boolean msat_term_is_floor(long var0, long var2);

    public static native boolean msat_term_is_array_read(long var0, long var2);

    public static native boolean msat_term_is_array_write(long var0, long var2);

    public static native boolean msat_term_is_array_const(long var0, long var2);

    public static native boolean msat_term_is_int_to_bv(long var0, long var2);

    public static native boolean msat_term_is_int_from_ubv(long var0, long var2);

    public static native boolean msat_term_is_int_from_sbv(long var0, long var2);

    public static native boolean msat_term_is_bv_concat(long var0, long var2);

    public static native boolean msat_term_is_bv_extract(long var0, long var2);

    public static native boolean msat_term_is_bv_or(long var0, long var2);

    public static native boolean msat_term_is_bv_xor(long var0, long var2);

    public static native boolean msat_term_is_bv_and(long var0, long var2);

    public static native boolean msat_term_is_bv_not(long var0, long var2);

    public static native boolean msat_term_is_bv_plus(long var0, long var2);

    public static native boolean msat_term_is_bv_minus(long var0, long var2);

    public static native boolean msat_term_is_bv_times(long var0, long var2);

    public static native boolean msat_term_is_bv_neg(long var0, long var2);

    public static native boolean msat_term_is_bv_udiv(long var0, long var2);

    public static native boolean msat_term_is_bv_urem(long var0, long var2);

    public static native boolean msat_term_is_bv_sdiv(long var0, long var2);

    public static native boolean msat_term_is_bv_srem(long var0, long var2);

    public static native boolean msat_term_is_bv_ult(long var0, long var2);

    public static native boolean msat_term_is_bv_uleq(long var0, long var2);

    public static native boolean msat_term_is_bv_slt(long var0, long var2);

    public static native boolean msat_term_is_bv_sleq(long var0, long var2);

    public static native boolean msat_term_is_bv_lshl(long var0, long var2);

    public static native boolean msat_term_is_bv_lshr(long var0, long var2);

    public static native boolean msat_term_is_bv_ashr(long var0, long var2);

    public static native boolean msat_term_is_bv_zext(long var0, long var2);

    public static native boolean msat_term_is_bv_sext(long var0, long var2);

    public static native boolean msat_term_is_bv_rol(long var0, long var2);

    public static native boolean msat_term_is_bv_ror(long var0, long var2);

    public static native boolean msat_term_is_bv_comp(long var0, long var2);

    public static native long msat_find_decl(long var0, String var2);

    public static native long msat_term_get_decl(long var0);

    public static native int msat_decl_id(long var0);

    public static native long msat_decl_get_return_type(long var0);

    public static native int msat_decl_get_tag(long var0, long var2);

    public static native int msat_decl_get_arity(long var0);

    public static native long msat_decl_get_arg_type(long var0, int var2);

    public static native String msat_decl_repr(long var0);

    public static native String msat_decl_get_name(long var0);

    public static native String msat_term_repr(long var0);

    public static native long msat_from_string(long var0, String var2);

    public static native long msat_from_smtlib1(long var0, String var2);

    public static native long msat_from_smtlib2(long var0, String var2);

    public static native String msat_to_smtlib1(long var0, long var2);

    public static native String msat_to_smtlib2(long var0, long var2);

    public static native String msat_to_smtlib2_term(long var0, long var2);

    public static native String msat_named_list_to_smtlib2(long var0, NamedTermsWrapper var2);

    public static native NamedTermsWrapper msat_named_list_from_smtlib2(long var0, String var2);

    public static native void msat_push_backtrack_point(long var0);

    public static native void msat_pop_backtrack_point(long var0);

    public static native void msat_reset_env(long var0);

    public static native void msat_assert_formula(long var0, long var2);

    private static native int msat_solve(long var0) throws InterruptedException;

    private static native int msat_solve_with_assumptions(long var0, long[] var2, int var3) throws InterruptedException;

    private static native int msat_all_sat(long var0, long[] var2, int var3, AllSatModelCallback var4) throws InterruptedException;

    public static native long[] msat_get_asserted_formulas(long var0);

    public static native long[] msat_get_theory_lemmas(long var0);

    public static native int msat_create_itp_group(long var0);

    public static native void msat_set_itp_group(long var0, int var2);

    private static native long msat_get_interpolant(long var0, int[] var2, int var3);

    public static native long msat_get_model_value(long var0, long var2);

    public static native long msat_get_model(long var0);

    public static native void msat_destroy_model(long var0);

    public static native long msat_model_create_iterator(long var0);

    public static native long msat_model_eval(long var0, long var2);

    private static native long msat_create_model_iterator(long var0);

    public static native boolean msat_model_iterator_has_next(long var0);

    public static native boolean msat_model_iterator_next(long var0, long[] var2, long[] var3);

    public static native void msat_destroy_model_iterator(long var0);

    public static native long[] msat_get_unsat_assumptions(long var0);

    public static native long[] msat_get_unsat_core(long var0);

    public static native long msat_set_termination_test(long var0, TerminationTest var2);

    public static native void msat_free_termination_test(long var0);

    public static native String msat_get_version();

    public static native String msat_last_error_message(long var0);

    @CanIgnoreReturnValue
    public static native long msat_push_minimize(long var0, long var2, @Nullable String var4, @Nullable String var5);

    @CanIgnoreReturnValue
    public static native long msat_push_maximize(long var0, long var2, @Nullable String var4, @Nullable String var5);

    @CanIgnoreReturnValue
    public static native long msat_push_minmax(long var0, int var2, long[] var3, @Nullable String var4, @Nullable String var5);

    @CanIgnoreReturnValue
    public static native long msat_push_maxmin(long var0, int var2, long[] var3, @Nullable String var4, @Nullable String var5);

    public static native void msat_assert_soft_formula(long var0, long var2, long var4, String var6);

    public static native long msat_create_objective_iterator(long var0);

    public static native int msat_objective_iterator_has_next(long var0);

    public static native int msat_objective_iterator_next(long var0, long[] var2);

    public static native void msat_destroy_objective_iterator(long var0);

    public static native int msat_objective_result(long var0, long var2);

    public static native long msat_objective_get_term(long var0, long var2);

    public static native long msat_objective_get_type(long var0, long var2);

    public static native void msat_set_model(long var0, long var2);

    public static native String msat_objective_get_search_stats(long var0, long var2);

    public static native int msat_objective_value_is_unbounded(long var0, long var2, int var4);

    public static native int msat_objective_value_is_plus_inf(long var0, long var2, int var4);

    public static native int msat_objective_value_is_minus_inf(long var0, long var2, int var4);

    public static native int msat_objective_value_is_strict(long var0, long var2, int var4);

    public static native long msat_objective_value_term(long var0, long var2, int var4);

    public static native String msat_objective_value_repr(long var0, long var2, int var4);

    private static native int msat_gc_env(long var0, long[] var2, int var3);

    static class NamedTermsWrapper {
        final long[] terms;
        final String[] names;

        NamedTermsWrapper(long[] pTerms, String[] pNames) {
            this.terms = pTerms;
            this.names = pNames;
        }
    }

    static interface TerminationTest {
        public boolean shouldTerminate() throws InterruptedException;
    }

    static interface AllSatModelCallback {
        public void callback(long[] var1) throws InterruptedException;
    }
}

