/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.logging;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

class LoggingBasicProverEnvironment<T>
implements BasicProverEnvironment<T> {
    private final BasicProverEnvironment<T> wrapped;
    final LogManager logger;
    private int level = 0;

    LoggingBasicProverEnvironment(BasicProverEnvironment<T> pWrapped, LogManager pLogger) {
        this.wrapped = (BasicProverEnvironment)Preconditions.checkNotNull(pWrapped);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
    }

    @Override
    public T push(BooleanFormula f) {
        this.logger.log(Level.FINE, new Object[]{"up to level " + this.level++});
        this.logger.log(Level.FINE, new Object[]{"formula pushed:", f});
        return this.wrapped.push(f);
    }

    @Override
    public void pop() {
        this.logger.log(Level.FINER, new Object[]{"down to level " + this.level--});
        this.wrapped.pop();
    }

    @Override
    public T addConstraint(BooleanFormula constraint) {
        return this.wrapped.addConstraint(constraint);
    }

    @Override
    public void push() {
        this.logger.log(Level.FINE, new Object[]{"up to level " + this.level++});
        this.wrapped.push();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        boolean result = this.wrapped.isUnsat();
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public Model getModel() throws SolverException {
        Model m = this.wrapped.getModel();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        ImmutableList<Model.ValueAssignment> m = this.wrapped.getModelAssignments();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }
}

