/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;

public class FunctionDeclarationImpl<F extends Formula, T>
implements FunctionDeclaration<F> {
    private final String name;
    private final FunctionDeclarationKind kind;
    private final ImmutableList<FormulaType<?>> argumentTypes;
    private final FormulaType<F> returnType;
    private final T solverDeclaration;

    private FunctionDeclarationImpl(String pName, FunctionDeclarationKind pKind, List<FormulaType<?>> pArgumentTypes, FormulaType<F> pReturnType, T pSolverDeclaration) {
        this.solverDeclaration = pSolverDeclaration;
        this.argumentTypes = ImmutableList.copyOf(pArgumentTypes);
        this.returnType = (FormulaType)Preconditions.checkNotNull(pReturnType);
        this.name = (String)Preconditions.checkNotNull((Object)pName);
        this.kind = (FunctionDeclarationKind)((Object)Preconditions.checkNotNull((Object)((Object)pKind)));
    }

    public static <F extends Formula, T> FunctionDeclaration<F> of(String name, FunctionDeclarationKind kind, List<FormulaType<?>> pArgumentTypes, FormulaType<F> pReturnType, T pDeclaration) {
        return new FunctionDeclarationImpl<F, T>(name, kind, pArgumentTypes, pReturnType, pDeclaration);
    }

    @Override
    public FunctionDeclarationKind getKind() {
        return this.kind;
    }

    public T getSolverDeclaration() {
        return this.solverDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<FormulaType<?>> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    public FormulaType<F> getType() {
        return this.returnType;
    }

    public String toString() {
        return String.format("%s (%s)", new Object[]{this.kind, this.name});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.name, this.argumentTypes, this.returnType});
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionDeclarationImpl)) {
            return false;
        }
        FunctionDeclarationImpl other = (FunctionDeclarationImpl)o;
        return this.name.equals(other.name) && this.kind.equals((Object)other.kind) && this.argumentTypes.equals(other.argumentTypes) && this.returnType.equals(other.returnType);
    }
}

