/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.microsoft.z3.Native;
import com.microsoft.z3.enumerations.Z3_ast_print_mode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.MoreFiles;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractSolverContext;
import org.sosy_lab.solver.z3.Z3ArrayFormulaManager;
import org.sosy_lab.solver.z3.Z3BitvectorFormulaManager;
import org.sosy_lab.solver.z3.Z3BooleanFormulaManager;
import org.sosy_lab.solver.z3.Z3FloatingPointFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3FormulaManager;
import org.sosy_lab.solver.z3.Z3IntegerFormulaManager;
import org.sosy_lab.solver.z3.Z3InterpolatingProver;
import org.sosy_lab.solver.z3.Z3OptimizationProver;
import org.sosy_lab.solver.z3.Z3QuantifiedFormulaManager;
import org.sosy_lab.solver.z3.Z3RationalFormulaManager;
import org.sosy_lab.solver.z3.Z3TheoremProver;
import org.sosy_lab.solver.z3.Z3UFManager;

@Options(prefix="solver.z3")
final class Z3SolverContext
extends AbstractSolverContext {
    @Option(secure=true, description="Engine to use for the optimization", values={"basic", "farkas", "symba"})
    String optimizationEngine = "basic";
    @Option(secure=true, description="Ordering for objectives in the optimization context", values={"lex", "pareto", "box"})
    String objectivePrioritizationMode = "box";
    @Option(secure=true, description="Dump failed interpolation queries to this file in SMTLIB2 format")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    @Nullable
    private PathCounterTemplate dumpFailedInterpolationQueries = PathCounterTemplate.ofFormatString((String)"z3-failed-interpolation-query.%d.smt2");
    private final ShutdownNotifier.ShutdownRequestListener interruptListener;
    private final long z3params;
    private final LogManager logger;
    private final Z3FormulaCreator creator;
    private final Z3FormulaManager manager;
    private static final String OPT_ENGINE_CONFIG_KEY = "optsmt_engine";
    private static final String OPT_PRIORITY_CONFIG_KEY = "priority";

    private Z3SolverContext(Z3FormulaCreator pFormulaCreator, Configuration config, long pZ3params, ShutdownNotifier.ShutdownRequestListener pInterruptListener, ShutdownNotifier pShutdownNotifier, LogManager pLogger, Z3FormulaManager pManager) throws InvalidConfigurationException {
        super(pManager);
        this.creator = pFormulaCreator;
        config.inject((Object)this);
        this.z3params = pZ3params;
        this.interruptListener = pInterruptListener;
        pShutdownNotifier.register(this.interruptListener);
        this.logger = pLogger;
        this.manager = pManager;
    }

    public static synchronized Z3SolverContext create(LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile, long randomSeed) throws InvalidConfigurationException {
        ExtraOptions extraOptions = new ExtraOptions();
        config.inject((Object)extraOptions);
        if (solverLogfile != null) {
            logger.log(Level.WARNING, new Object[]{"Z3 does not support dumping a log file in SMTLIB format. Please use the option solver.z3.log for a Z3-specific log instead."});
        }
        if (NativeLibraries.OS.guessOperatingSystem() == NativeLibraries.OS.WINDOWS) {
            System.loadLibrary("libz3");
            System.loadLibrary("libz3java");
        }
        System.loadLibrary("z3");
        System.loadLibrary("z3java");
        if (extraOptions.log != null) {
            Path absolutePath = extraOptions.log.toAbsolutePath();
            try {
                MoreFiles.writeFile((Path)absolutePath, (Charset)StandardCharsets.US_ASCII, (Object)"");
                Native.openLog((String)absolutePath.toString());
            }
            catch (IOException e) {
                logger.logUserException(Level.WARNING, (Throwable)e, "Cannot write Z3 log file");
            }
        }
        long cfg = Native.mkConfig();
        Native.setParamValue((long)cfg, (String)"MODEL", (String)"true");
        if (extraOptions.requireProofs) {
            Native.setParamValue((long)cfg, (String)"PROOF", (String)"true");
        }
        Native.globalParamSet((String)"smt.random_seed", (String)String.valueOf(randomSeed));
        long context = Native.mkContextRc((long)cfg);
        ShutdownNotifier.ShutdownRequestListener interruptListener = reason -> Native.interrupt((long)context);
        Native.delConfig((long)cfg);
        long boolSort = Native.mkBoolSort((long)context);
        Native.incRef((long)context, (long)Native.sortToAst((long)context, (long)boolSort));
        long integerSort = Native.mkIntSort((long)context);
        Native.incRef((long)context, (long)Native.sortToAst((long)context, (long)integerSort));
        long realSort = Native.mkRealSort((long)context);
        Native.incRef((long)context, (long)Native.sortToAst((long)context, (long)realSort));
        Native.setAstPrintMode((long)context, (int)Z3_ast_print_mode.Z3_PRINT_SMTLIB2_COMPLIANT.toInt());
        long z3params = Native.mkParams((long)context);
        Native.paramsIncRef((long)context, (long)z3params);
        Native.paramsSetUint((long)context, (long)z3params, (long)Native.mkStringSymbol((long)context, (String)":random-seed"), (int)((int)randomSeed));
        Z3FormulaCreator creator = new Z3FormulaCreator(context, boolSort, integerSort, realSort, config, pShutdownNotifier);
        Z3UFManager functionTheory = new Z3UFManager(creator);
        Z3BooleanFormulaManager booleanTheory = new Z3BooleanFormulaManager(creator);
        Z3IntegerFormulaManager integerTheory = new Z3IntegerFormulaManager(creator);
        Z3RationalFormulaManager rationalTheory = new Z3RationalFormulaManager(creator);
        Z3BitvectorFormulaManager bitvectorTheory = new Z3BitvectorFormulaManager(creator);
        Z3FloatingPointFormulaManager floatingPointTheory = new Z3FloatingPointFormulaManager(creator, functionTheory);
        Z3QuantifiedFormulaManager quantifierManager = new Z3QuantifiedFormulaManager(creator);
        Z3ArrayFormulaManager arrayManager = new Z3ArrayFormulaManager(creator);
        Native.setInternalErrorHandler((long)context);
        Z3FormulaManager manager = new Z3FormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, floatingPointTheory, quantifierManager, arrayManager);
        return new Z3SolverContext(creator, config, z3params, interruptListener, pShutdownNotifier, logger, manager);
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        return new Z3TheoremProver(this.creator, this.manager, this.z3params, options);
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0() {
        return new Z3InterpolatingProver(this.creator, this.z3params, this.logger, this.dumpFailedInterpolationQueries);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        Z3OptimizationProver out = new Z3OptimizationProver(this.getFormulaManager(), this.creator, this.logger);
        out.setParam(OPT_ENGINE_CONFIG_KEY, this.optimizationEngine);
        out.setParam(OPT_PRIORITY_CONFIG_KEY, this.objectivePrioritizationMode);
        return out;
    }

    @Override
    public String getVersion() {
        Native.IntPtr major = new Native.IntPtr();
        Native.IntPtr minor = new Native.IntPtr();
        Native.IntPtr build = new Native.IntPtr();
        Native.IntPtr revision = new Native.IntPtr();
        Native.getVersion((Native.IntPtr)major, (Native.IntPtr)minor, (Native.IntPtr)build, (Native.IntPtr)revision);
        return "Z3 " + major.value + "." + minor.value + "." + build.value + "." + revision.value;
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.Z3;
    }

    @Override
    public void close() {
        long context = (Long)this.creator.getEnv();
        this.creator.forceClose();
        Native.paramsDecRef((long)context, (long)this.z3params);
        Native.closeLog();
        Native.delContext((long)context);
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return true;
    }

    @Options(prefix="solver.z3")
    private static class ExtraOptions {
        @Option(secure=true, description="Require proofs from SMT solver")
        boolean requireProofs = true;
        @Option(secure=true, description="Activate replayable logging in Z3. The log can be given as an input to the solver and replayed.")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        @Nullable
        Path log = null;

        private ExtraOptions() {
        }
    }
}

