/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.util.Collection;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.z3.Z3AbstractProver;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3SolverException;

abstract class Z3SolverBasedProver<T>
extends Z3AbstractProver<T> {
    protected final long z3solver = Native.mkSolver((long)this.z3context);
    private int level = 0;

    Z3SolverBasedProver(Z3FormulaCreator pCreator, long z3params) {
        super(pCreator);
        Native.solverIncRef((long)this.z3context, (long)this.z3solver);
        Native.solverSetParams((long)this.z3context, (long)this.z3solver, (long)z3params);
    }

    @Override
    public boolean isUnsat() throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            result = Native.solverCheck((long)this.z3context, (long)this.z3solver);
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            result = Native.solverCheckAssumptions((long)this.z3context, (long)this.z3solver, (int)assumptions.size(), (long[])assumptions.stream().mapToLong(this.creator::extractInfo).toArray());
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    protected final void undefinedStatusToException(int solverStatus) throws Z3SolverException, InterruptedException {
        if (solverStatus == Z3_lbool.Z3_L_UNDEF.toInt()) {
            this.creator.shutdownNotifier.shutdownIfNecessary();
            throw new Z3SolverException("Solver returned 'unknown' status, reason: " + Native.solverGetReasonUnknown((long)this.z3context, (long)this.z3solver));
        }
    }

    @Override
    protected long getZ3Model() {
        return Native.solverGetModel((long)this.z3context, (long)this.z3solver);
    }

    @CanIgnoreReturnValue
    protected long addConstraint0(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long e = this.creator.extractInfo(f);
        Native.incRef((long)this.z3context, (long)e);
        Native.solverAssert((long)this.z3context, (long)this.z3solver, (long)e);
        Native.decRef((long)this.z3context, (long)e);
        return e;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ++this.level;
        Native.solverPush((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) >= 1 ? 1 : 0) != 0);
        --this.level;
        Native.solverPop((long)this.z3context, (long)this.z3solver, (int)1);
    }

    protected int getLevel() {
        return this.level;
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) >= 0 ? 1 : 0) != 0, (Object)"a negative number of scopes is not allowed");
        while (this.level > 0) {
            this.pop();
        }
        Native.solverDecRef((long)this.z3context, (long)this.z3solver);
        this.closed = true;
    }

    public String toString() {
        if (this.closed) {
            return "Closed Z3Solver";
        }
        return Native.solverToString((long)this.z3context, (long)this.z3solver);
    }
}

