/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;

abstract class Z3NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Long, Long, Long, ParamFormulaType, ResultFormulaType, Long> {
    protected final long z3context;

    Z3NumeralFormulaManager(Z3FormulaCreator pCreator) {
        super(pCreator);
        this.z3context = (Long)pCreator.getEnv();
    }

    protected abstract long getNumeralType();

    @Override
    protected boolean isNumeral(Long val) {
        return Native.isNumeralAst((long)this.z3context, (long)val);
    }

    @Override
    protected Long makeNumberImpl(long i) {
        long sort = this.getNumeralType();
        return Native.mkInt64((long)this.z3context, (long)i, (long)sort);
    }

    @Override
    protected Long makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Long makeNumberImpl(String pI) {
        long sort = this.getNumeralType();
        return Native.mkNumeral((long)this.z3context, (String)pI, (long)sort);
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = this.getNumeralType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    public Long negate(Long pNumber) {
        long sort = Native.getSort((long)this.z3context, (long)pNumber);
        long minusOne = Native.mkInt((long)this.z3context, (int)-1, (long)sort);
        return Native.mkMul((long)this.z3context, (int)2, (long[])new long[]{minusOne, pNumber});
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Native.mkAdd((long)this.z3context, (int)2, (long[])new long[]{pNumber1, pNumber2});
    }

    @Override
    public Long sumImpl(List<Long> operands) {
        return Native.mkAdd((long)this.z3context, (int)operands.size(), (long[])Longs.toArray(operands));
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Native.mkSub((long)this.z3context, (int)2, (long[])new long[]{pNumber1, pNumber2});
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        return Native.mkDiv((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Native.mkMul((long)this.z3context, (int)2, (long[])new long[]{pNumber1, pNumber2});
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return Native.mkTrue((long)this.z3context);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Native.mkEq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2) {
        return Native.mkGt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkGe((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2) {
        return Native.mkLt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkLe((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }
}

