/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.io.MoreFiles;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.visitors.DefaultFormulaVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3SolverBasedProver;

class Z3InterpolatingProver
extends Z3SolverBasedProver<Long>
implements InterpolatingProverEnvironment<Long> {
    private final LogManager logger;
    @Nullable
    private final PathCounterTemplate dumpFailedInterpolationQueries;
    private final Deque<List<Long>> assertedFormulas = new ArrayDeque<List<Long>>();

    Z3InterpolatingProver(Z3FormulaCreator creator, long z3params, LogManager pLogger, @Nullable PathCounterTemplate pDumpFailedInterpolationQueries) {
        super(creator, z3params);
        this.logger = pLogger;
        this.dumpFailedInterpolationQueries = pDumpFailedInterpolationQueries;
        this.assertedFormulas.push(new ArrayList());
    }

    @Override
    public void pop() {
        Preconditions.checkState((this.getLevel() == this.assertedFormulas.size() - 1 ? 1 : 0) != 0);
        super.pop();
        this.assertedFormulas.pop();
    }

    @Override
    public Long addConstraint(BooleanFormula f) {
        long e = super.addConstraint0(f);
        this.assertedFormulas.peek().add(e);
        return e;
    }

    @Override
    public void push() {
        Preconditions.checkState((this.getLevel() == this.assertedFormulas.size() - 1 ? 1 : 0) != 0);
        super.push();
        this.assertedFormulas.push(new ArrayList());
    }

    @Override
    public BooleanFormula getInterpolant(List<Long> formulasOfA) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        LinkedList formulasOfB = new LinkedList();
        this.assertedFormulas.forEach(formulasOfB::addAll);
        for (long af : formulasOfA) {
            boolean check = formulasOfB.remove(af);
            assert (check) : "formula from A must be part of all asserted formulas";
        }
        return (BooleanFormula)Iterables.getOnlyElement(this.getSeqInterpolants((List<Set<Long>>)ImmutableList.of((Object)Sets.newHashSet(formulasOfA), (Object)Sets.newHashSet(formulasOfB))));
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Long>> partitionedFormulas) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionedFormulas.size() >= 2 ? 1 : 0) != 0, (Object)"at least 2 partitions needed for interpolation");
        return this.getTreeInterpolants(partitionedFormulas, new int[partitionedFormulas.size()]);
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<Long>> partitionedFormulas, int[] startOfSubTree) throws InterruptedException, SolverException {
        long interpolationResult;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long[] conjunctionFormulas = new long[partitionedFormulas.size()];
        for (int i = 0; i < partitionedFormulas.size(); ++i) {
            long conjunction = Native.mkAnd((long)this.z3context, (int)partitionedFormulas.get(i).size(), (long[])Longs.toArray((Collection)partitionedFormulas.get(i)));
            Native.incRef((long)this.z3context, (long)conjunction);
            conjunctionFormulas[i] = conjunction;
        }
        long[] interpolationFormulas = new long[partitionedFormulas.size()];
        ArrayDeque<Z3TreeInterpolant> stack = new ArrayDeque<Z3TreeInterpolant>();
        int lastSubtree = -1;
        for (int i = 0; i < startOfSubTree.length; ++i) {
            long interpolationPoint;
            long conjunction;
            int currentSubtree = startOfSubTree[i];
            if (currentSubtree > lastSubtree) {
                conjunction = conjunctionFormulas[i];
            } else {
                ArrayList<Long> children = new ArrayList<Long>();
                while (!stack.isEmpty() && currentSubtree <= ((Z3TreeInterpolant)stack.peek()).getRootOfTree()) {
                    children.add(0, ((Z3TreeInterpolant)stack.pop()).getInterpolationPoint());
                }
                children.add(conjunctionFormulas[i]);
                conjunction = Native.mkAnd((long)this.z3context, (int)children.size(), (long[])Longs.toArray(children));
            }
            if (i == startOfSubTree.length - 1) {
                interpolationPoint = conjunction;
                Preconditions.checkState((currentSubtree == 0 ? 1 : 0) != 0, (Object)"subtree of root should start at 0.");
                Preconditions.checkState((boolean)stack.isEmpty(), (Object)"root should be the last element in the stack.");
            } else {
                interpolationPoint = Native.mkInterpolant((long)this.z3context, (long)conjunction);
            }
            Native.incRef((long)this.z3context, (long)interpolationPoint);
            interpolationFormulas[i] = interpolationPoint;
            stack.push(new Z3TreeInterpolant(currentSubtree, interpolationPoint));
            lastSubtree = currentSubtree;
        }
        Preconditions.checkState((((Z3TreeInterpolant)stack.peek()).getRootOfTree() == 0 ? 1 : 0) != 0, (Object)"subtree of root should start at 0.");
        long root = ((Z3TreeInterpolant)stack.pop()).getInterpolationPoint();
        Preconditions.checkState((boolean)stack.isEmpty(), (Object)"root should have been the last element in the stack.");
        long proof = Native.solverGetProof((long)this.z3context, (long)this.z3solver);
        Native.incRef((long)this.z3context, (long)proof);
        try {
            interpolationResult = Native.getInterpolant((long)this.z3context, (long)proof, (long)root, (long)Native.mkParams((long)this.z3context));
        }
        catch (Z3Exception e) {
            if (this.dumpFailedInterpolationQueries != null && !this.creator.shutdownNotifier.shouldShutdown()) {
                try (Writer dumpFile = MoreFiles.openOutputFile((Path)this.dumpFailedInterpolationQueries.getFreshPath(), (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);){
                    dumpFile.write(Native.solverToString((long)this.z3context, (long)this.z3solver));
                    dumpFile.write("\n(compute-interpolant ");
                    dumpFile.write(Native.astToString((long)this.z3context, (long)root));
                    dumpFile.write(")\n");
                }
                catch (IOException e2) {
                    this.logger.logUserException(Level.WARNING, (Throwable)e2, "Could not dump failed interpolation query to file");
                }
            }
            if ("theory not supported by interpolation or bad proof".equals(e.getMessage())) {
                throw new SolverException(e.getMessage(), e);
            }
            throw this.creator.handleZ3Exception(e);
        }
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (int i = 0; i < partitionedFormulas.size() - 1; ++i) {
            result.add(this.creator.encapsulateBoolean(Native.astVectorGet((long)this.z3context, (long)interpolationResult, (int)i)));
        }
        Native.decRef((long)this.z3context, (long)proof);
        for (long partition : conjunctionFormulas) {
            Native.decRef((long)this.z3context, (long)partition);
        }
        for (long partition : interpolationFormulas) {
            Native.decRef((long)this.z3context, (long)partition);
        }
        this.checkInterpolantsForUnboundVariables(result);
        return result;
    }

    private void checkInterpolantsForUnboundVariables(List<BooleanFormula> itps) throws SolverException {
        final ArrayList unboundVariables = new ArrayList(1);
        DefaultFormulaVisitor<TraversalProcess> unboundVariablesCollector = new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            public TraversalProcess visitBoundVariable(Formula f, int deBruijnIdx) {
                unboundVariables.add(f);
                return TraversalProcess.ABORT;
            }

            @Override
            public TraversalProcess visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQ, List<Formula> pBoundVariables, BooleanFormula pBody) {
                return TraversalProcess.SKIP;
            }

            @Override
            protected TraversalProcess visitDefault(Formula pF) {
                return TraversalProcess.CONTINUE;
            }
        };
        for (BooleanFormula itp : itps) {
            this.creator.visitRecursively((FormulaVisitor<TraversalProcess>)unboundVariablesCollector, itp);
            if (unboundVariables.isEmpty()) continue;
            throw new SolverException("Unbound variable " + unboundVariables.get(0) + " in interpolant " + itp);
        }
    }

    @Override
    public void close() {
        super.close();
        Preconditions.checkState((this.assertedFormulas.size() == 1 ? 1 : 0) != 0);
        this.assertedFormulas.clear();
    }

    private static class Z3TreeInterpolant {
        private final int rootOfSubTree;
        private final long interpolationPoint;

        private Z3TreeInterpolant(int pRootOfSubtree, long pInterpolationPoint) {
            this.rootOfSubTree = pRootOfSubtree;
            this.interpolationPoint = pInterpolationPoint;
        }

        private int getRootOfTree() {
            return this.rootOfSubTree;
        }

        private long getInterpolationPoint() {
            return this.interpolationPoint;
        }
    }
}

