/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.microsoft.z3.Native;
import java.math.BigDecimal;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NumeralFormulaManager;

class Z3IntegerFormulaManager
extends Z3NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    Z3IntegerFormulaManager(Z3FormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return (Long)this.decimalAsInteger(pNumber);
    }

    @Override
    public Long modulo(Long pNumber1, Long pNumber2) {
        return Native.mkMod((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        if (pModulo > 0L) {
            long n = this.makeNumberImpl(pModulo);
            long x = this.subtract(pNumber1, pNumber2);
            return Native.mkEq((long)this.z3context, (long)x, (long)Native.mkMul((long)this.z3context, (int)2, (long[])new long[]{n, Native.mkDiv((long)this.z3context, (long)x, (long)n)}));
        }
        return Native.mkTrue((long)this.z3context);
    }
}

