/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import com.microsoft.z3.enumerations.Z3_symbol_kind;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.z3.Z3Formula;
import org.sosy_lab.solver.z3.Z3FormulaManager;

@Options(prefix="solver.z3")
class Z3FormulaCreator
extends FormulaCreator<Long, Long, Long, Long> {
    private static final Map<Integer, Object> Z3_CONSTANTS = ImmutableMap.builder().put((Object)Z3_decl_kind.Z3_OP_TRUE.toInt(), (Object)true).put((Object)Z3_decl_kind.Z3_OP_FALSE.toInt(), (Object)false).put((Object)Z3_decl_kind.Z3_OP_FPA_PLUS_ZERO.toInt(), (Object)0.0).put((Object)Z3_decl_kind.Z3_OP_FPA_MINUS_ZERO.toInt(), (Object)-0.0).put((Object)Z3_decl_kind.Z3_OP_FPA_PLUS_INF.toInt(), (Object)Double.POSITIVE_INFINITY).put((Object)Z3_decl_kind.Z3_OP_FPA_MINUS_INF.toInt(), (Object)Double.NEGATIVE_INFINITY).put((Object)Z3_decl_kind.Z3_OP_FPA_NAN.toInt(), (Object)Double.NaN).build();
    private static final ImmutableSet<String> Z3_INTERRUPT_ERRORS = ImmutableSet.of((Object)"canceled", (Object)"interpolation cannot proceed without a model", (Object)"Proof error!");
    @Option(secure=true, description="Whether to use PhantomReferences for discarding Z3 AST")
    private boolean usePhantomReferences = false;
    private final Table<Long, Long, Long> allocatedArraySorts = HashBasedTable.create();
    private final ReferenceQueue<Z3Formula> referenceQueue = new ReferenceQueue();
    private final Map<PhantomReference<? extends Z3Formula>, Long> referenceMap = Maps.newIdentityHashMap();
    private final Timer cleanupTimer = new Timer();
    protected final ShutdownNotifier shutdownNotifier;

    Z3FormulaCreator(long pEnv, long pBoolType, long pIntegerType, long pRealType, Configuration config, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        super(pEnv, pBoolType, pIntegerType, pRealType);
        this.shutdownNotifier = pShutdownNotifier;
        config.inject((Object)this);
    }

    final Z3Exception handleZ3Exception(Z3Exception e) throws Z3Exception, InterruptedException {
        if (Z3_INTERRUPT_ERRORS.contains((Object)e.getMessage())) {
            this.shutdownNotifier.shutdownIfNecessary();
        }
        throw e;
    }

    @Override
    public Long makeVariable(Long type, String varName) {
        long z3context = (Long)this.getEnv();
        long symbol = Native.mkStringSymbol((long)z3context, (String)varName);
        return Native.mkConst((long)z3context, (long)symbol, (long)type);
    }

    @Override
    public Long extractInfo(Formula pT) {
        return Z3FormulaManager.getZ3Expr(pT);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        Long term = this.extractInfo(pFormula);
        return this.getFormulaType(term);
    }

    public FormulaType<?> getFormulaTypeFromSort(Long pSort) {
        long z3context = (Long)this.getEnv();
        Z3_sort_kind sortKind = Z3_sort_kind.fromInt((int)Native.getSortKind((long)z3context, (long)pSort));
        switch (sortKind) {
            case Z3_BOOL_SORT: {
                return FormulaType.BooleanType;
            }
            case Z3_INT_SORT: {
                return FormulaType.IntegerType;
            }
            case Z3_REAL_SORT: {
                return FormulaType.RationalType;
            }
            case Z3_BV_SORT: {
                return FormulaType.getBitvectorTypeWithSize(Native.getBvSortSize((long)z3context, (long)pSort));
            }
            case Z3_ARRAY_SORT: {
                long domainSort = Native.getArraySortDomain((long)z3context, (long)pSort);
                long rangeSort = Native.getArraySortRange((long)z3context, (long)pSort);
                return FormulaType.getArrayType(this.getFormulaTypeFromSort(domainSort), this.getFormulaTypeFromSort(rangeSort));
            }
            case Z3_FLOATING_POINT_SORT: {
                return FormulaType.getFloatingPointType(Native.fpaGetEbits((long)z3context, (long)pSort), Native.fpaGetSbits((long)z3context, (long)pSort));
            }
            case Z3_ROUNDING_MODE_SORT: {
                return FormulaType.FloatingPointRoundingModeType;
            }
            case Z3_DATATYPE_SORT: 
            case Z3_RELATION_SORT: 
            case Z3_FINITE_DOMAIN_SORT: 
            case Z3_SEQ_SORT: 
            case Z3_RE_SORT: 
            case Z3_UNKNOWN_SORT: 
            case Z3_UNINTERPRETED_SORT: {
                throw new IllegalArgumentException("Unknown formula type " + Native.sortToString((long)z3context, (long)pSort) + " with sort " + sortKind);
            }
        }
        throw new UnsupportedOperationException("Unexpected state.");
    }

    @Override
    public FormulaType<?> getFormulaType(Long pFormula) {
        long sort = Native.getSort((long)((Long)this.getEnv()), (long)pFormula);
        return this.getFormulaTypeFromSort(sort);
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TR> getArrayFormulaElementType(ArrayFormula<TD, TR> pArray) {
        return ((Z3Formula.Z3ArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TD> getArrayFormulaIndexType(ArrayFormula<TD, TR> pArray) {
        return ((Z3Formula.Z3ArrayFormula)pArray).getIndexType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> ArrayFormula<TD, TR> encapsulateArray(Long pTerm, FormulaType<TD> pIndexType, FormulaType<TR> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType)));
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3ArrayFormula<TD, TR>((Long)this.getEnv(), pTerm, pIndexType, pElementType), pTerm);
    }

    private <T extends Z3Formula> T storePhantomReference(T out, Long pTerm) {
        if (this.usePhantomReferences) {
            PhantomReference<Z3Formula> ref = new PhantomReference<Z3Formula>(out, this.referenceQueue);
            this.referenceMap.put(ref, pTerm);
        }
        return out;
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Long pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm)) || pType.equals(FormulaType.RationalType) && this.getFormulaType(pTerm).equals(FormulaType.IntegerType)) : String.format("Trying to encapsulate formula of type %s as %s", this.getFormulaType(pTerm), pType);
        this.cleanupReferences();
        if (pType.isBooleanType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3BooleanFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3IntegerFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isRationalType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3RationalFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3BitvectorFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3FloatingPointFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isFloatingPointRoundingModeType()) {
            return (T)this.storePhantomReference(new Z3Formula.Z3FloatingPointRoundingModeFormula((Long)this.getEnv(), pTerm), pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)this.storePhantomReference(new Z3Formula.Z3ArrayFormula((Long)this.getEnv(), pTerm, arrFt.getIndexType(), arrFt.getElementType()), pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in Z3");
    }

    @Override
    public BooleanFormula encapsulateBoolean(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3BooleanFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3BitvectorFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    protected FloatingPointFormula encapsulateFloatingPoint(Long pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType());
        this.cleanupReferences();
        return this.storePhantomReference(new Z3Formula.Z3FloatingPointFormula((Long)this.getEnv(), pTerm), pTerm);
    }

    @Override
    public Long getArrayType(Long pIndexType, Long pElementType) {
        Long allocatedArraySort = (Long)this.allocatedArraySorts.get((Object)pIndexType, (Object)pElementType);
        if (allocatedArraySort == null) {
            allocatedArraySort = Native.mkArraySort((long)((Long)this.getEnv()), (long)pIndexType, (long)pElementType);
            Native.incRef((long)((Long)this.getEnv()), (long)allocatedArraySort);
            this.allocatedArraySorts.put((Object)pIndexType, (Object)pElementType, (Object)allocatedArraySort);
        }
        return allocatedArraySort;
    }

    @Override
    public Long getBitvectorType(int pBitwidth) {
        Preconditions.checkArgument((pBitwidth > 0 ? 1 : 0) != 0, (String)"Cannot use bitvector type with size %s", (Object[])new Object[]{pBitwidth});
        long bvSort = Native.mkBvSort((long)((Long)this.getEnv()), (int)pBitwidth);
        Native.incRef((long)((Long)this.getEnv()), (long)Native.sortToAst((long)((Long)this.getEnv()), (long)bvSort));
        return bvSort;
    }

    @Override
    public Long getFloatingPointType(FormulaType.FloatingPointType type) {
        long fpSort = Native.mkFpaSort((long)((Long)this.getEnv()), (int)type.getExponentSize(), (int)type.getMantissaSize());
        Native.incRef((long)((Long)this.getEnv()), (long)Native.sortToAst((long)((Long)this.getEnv()), (long)fpSort));
        return fpSort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupReferences() {
        if (!this.usePhantomReferences) {
            return;
        }
        this.cleanupTimer.start();
        try {
            Reference<Z3Formula> ref;
            while ((ref = this.referenceQueue.poll()) != null) {
                long z3ast = this.referenceMap.remove(ref);
                Native.decRef((long)((Long)this.environment), (long)z3ast);
            }
        }
        finally {
            this.cleanupTimer.stop();
        }
    }

    private String getAppName(long f) {
        long funcDecl = Native.getAppDecl((long)((Long)this.environment), (long)f);
        long symbol = Native.getDeclName((long)((Long)this.environment), (long)funcDecl);
        return this.symbolToString(symbol);
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Long f) {
        switch (Z3_ast_kind.fromInt((int)Native.getAstKind((long)((Long)this.environment), (long)f))) {
            case Z3_NUMERAL_AST: {
                return visitor.visitConstant(formula, this.convertValue(f));
            }
            case Z3_APP_AST: {
                int arity = Native.getAppNumArgs((long)((Long)this.environment), (long)f);
                if (arity == 0) {
                    int declKind = Native.getDeclKind((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)f));
                    Object value = Z3_CONSTANTS.get(declKind);
                    if (value != null) {
                        return visitor.visitConstant(formula, value);
                    }
                    if (declKind == Z3_decl_kind.Z3_OP_FPA_NUM.toInt() || Native.getSortKind((long)((Long)this.environment), (long)Native.getSort((long)((Long)this.environment), (long)f)) == Z3_sort_kind.Z3_ROUNDING_MODE_SORT.toInt()) {
                        return visitor.visitConstant(formula, this.convertValue(f));
                    }
                    return visitor.visitFreeVariable(formula, this.getAppName(f));
                }
                ImmutableList.Builder args = ImmutableList.builder();
                ImmutableList.Builder argTypes = ImmutableList.builder();
                for (int i = 0; i < arity; ++i) {
                    long arg = Native.getAppArg((long)((Long)this.environment), (long)f, (int)i);
                    FormulaType<?> argumentType = this.getFormulaType(arg);
                    args.add(this.encapsulate(argumentType, arg));
                    argTypes.add(argumentType);
                }
                return visitor.visitFunction(formula, (List<Formula>)args.build(), FunctionDeclarationImpl.of(this.getAppName(f), this.getDeclarationKind(f), argTypes.build(), this.getFormulaType(f), Native.getAppDecl((long)((Long)this.environment), (long)f)));
            }
            case Z3_VAR_AST: {
                int deBruijnIdx = Native.getIndexValue((long)((Long)this.environment), (long)f);
                return visitor.visitBoundVariable(formula, deBruijnIdx);
            }
            case Z3_QUANTIFIER_AST: {
                BooleanFormula body = this.encapsulateBoolean(Native.getQuantifierBody((long)((Long)this.environment), (long)f));
                QuantifiedFormulaManager.Quantifier q = Native.isQuantifierForall((long)((Long)this.environment), (long)f) ? QuantifiedFormulaManager.Quantifier.FORALL : QuantifiedFormulaManager.Quantifier.EXISTS;
                return visitor.visitQuantifier((BooleanFormula)formula, q, this.getBoundVars(f), body);
            }
        }
        throw new UnsupportedOperationException("Input should be a formula AST, got unexpected type instead");
    }

    protected String symbolToString(long symbol) {
        switch (Z3_symbol_kind.fromInt((int)Native.getSymbolKind((long)((Long)this.environment), (long)symbol))) {
            case Z3_STRING_SYMBOL: {
                return Native.getSymbolString((long)((Long)this.environment), (long)symbol);
            }
            case Z3_INT_SYMBOL: {
                return "#" + Native.getSymbolInt((long)((Long)this.environment), (long)symbol);
            }
        }
        throw new UnsupportedOperationException("Unexpected state");
    }

    private List<Formula> getBoundVars(long f) {
        int numBound = Native.getQuantifierNumBound((long)((Long)this.environment), (long)f);
        ArrayList<Formula> boundVars = new ArrayList<Formula>(numBound);
        for (int i = 0; i < numBound; ++i) {
            long varName = Native.getQuantifierBoundName((long)((Long)this.environment), (long)f, (int)i);
            long varSort = Native.getQuantifierBoundSort((long)((Long)this.environment), (long)f, (int)i);
            boundVars.add((Formula)this.encapsulate(this.getFormulaTypeFromSort(varSort), Native.mkConst((long)((Long)this.environment), (long)varName, (long)varSort)));
        }
        return boundVars;
    }

    private FunctionDeclarationKind getDeclarationKind(long f) {
        assert (Native.getArity((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)f)) > 0) : "Variables should be handled in other branch.";
        if (this.getAppName(f).equals("div0")) {
            return FunctionDeclarationKind.OTHER;
        }
        Z3_decl_kind decl = Z3_decl_kind.fromInt((int)Native.getDeclKind((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)f)));
        switch (decl) {
            case Z3_OP_AND: {
                return FunctionDeclarationKind.AND;
            }
            case Z3_OP_NOT: {
                return FunctionDeclarationKind.NOT;
            }
            case Z3_OP_OR: {
                return FunctionDeclarationKind.OR;
            }
            case Z3_OP_IFF: {
                return FunctionDeclarationKind.IFF;
            }
            case Z3_OP_ITE: {
                return FunctionDeclarationKind.ITE;
            }
            case Z3_OP_XOR: {
                return FunctionDeclarationKind.XOR;
            }
            case Z3_OP_DISTINCT: {
                return FunctionDeclarationKind.DISTINCT;
            }
            case Z3_OP_IMPLIES: {
                return FunctionDeclarationKind.IMPLIES;
            }
            case Z3_OP_SUB: {
                return FunctionDeclarationKind.SUB;
            }
            case Z3_OP_ADD: {
                return FunctionDeclarationKind.ADD;
            }
            case Z3_OP_DIV: {
                return FunctionDeclarationKind.DIV;
            }
            case Z3_OP_MUL: {
                return FunctionDeclarationKind.MUL;
            }
            case Z3_OP_MOD: {
                return FunctionDeclarationKind.MODULO;
            }
            case Z3_OP_UNINTERPRETED: {
                return FunctionDeclarationKind.UF;
            }
            case Z3_OP_LT: {
                return FunctionDeclarationKind.LT;
            }
            case Z3_OP_LE: {
                return FunctionDeclarationKind.LTE;
            }
            case Z3_OP_GT: {
                return FunctionDeclarationKind.GT;
            }
            case Z3_OP_GE: {
                return FunctionDeclarationKind.GTE;
            }
            case Z3_OP_EQ: {
                return FunctionDeclarationKind.EQ;
            }
            case Z3_OP_STORE: {
                return FunctionDeclarationKind.STORE;
            }
            case Z3_OP_SELECT: {
                return FunctionDeclarationKind.SELECT;
            }
            case Z3_OP_TRUE: 
            case Z3_OP_FALSE: 
            case Z3_OP_ANUM: 
            case Z3_OP_AGNUM: {
                throw new UnsupportedOperationException("Unexpected state: constants not expected");
            }
            case Z3_OP_OEQ: {
                throw new UnsupportedOperationException("Unexpected state: not a proof");
            }
            case Z3_OP_INTERP: {
                throw new UnsupportedOperationException("Unexpected state: interpolant marks not expected");
            }
            case Z3_OP_UMINUS: {
                return FunctionDeclarationKind.UMINUS;
            }
            case Z3_OP_IDIV: {
                return FunctionDeclarationKind.DIV;
            }
        }
        return FunctionDeclarationKind.OTHER;
    }

    public boolean isConstant(long value) {
        return Native.isNumeralAst((long)((Long)this.environment), (long)value) || Native.isAlgebraicNumber((long)((Long)this.environment), (long)value) || Z3FormulaCreator.isOP((Long)this.environment, value, Z3_decl_kind.Z3_OP_TRUE.toInt()) || Z3FormulaCreator.isOP((Long)this.environment, value, Z3_decl_kind.Z3_OP_FALSE.toInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convertValue(long value) {
        assert (this.isConstant(value)) : "value is not constant";
        Native.incRef((long)((Long)this.environment), (long)value);
        Object constantValue = Z3_CONSTANTS.get(Native.getDeclKind((long)((Long)this.environment), (long)Native.getAppDecl((long)((Long)this.environment), (long)value)));
        if (constantValue != null) {
            return constantValue;
        }
        try {
            FormulaType<?> type = this.getFormulaType(value);
            if (type.isBooleanType()) {
                Boolean bl = Z3FormulaCreator.isOP((Long)this.environment, value, Z3_decl_kind.Z3_OP_TRUE.toInt());
                return bl;
            }
            if (type.isIntegerType()) {
                BigInteger bigInteger = new BigInteger(Native.getNumeralString((long)((Long)this.environment), (long)value));
                return bigInteger;
            }
            if (type.isRationalType()) {
                Rational rational = Rational.ofString((String)Native.getNumeralString((long)((Long)this.environment), (long)value));
                return rational;
            }
            if (type.isBitvectorType()) {
                BigInteger bigInteger = new BigInteger(Native.getNumeralString((long)((Long)this.environment), (long)value));
                return bigInteger;
            }
            if (type.isFloatingPointType()) {
                Object object = this.convertValue(Native.simplify((long)((Long)this.environment), (long)Native.mkFpaToReal((long)((Long)this.environment), (long)value)));
                return object;
            }
            String string = Native.astToString((long)((Long)this.environment), (long)value);
            return string;
        }
        finally {
            Native.decRef((long)((Long)this.environment), (long)value);
        }
    }

    @Override
    public Long callFunctionImpl(FunctionDeclarationImpl<?, Long> declaration, List<Long> args) {
        return Native.mkApp((long)((Long)this.environment), (long)declaration.getSolverDeclaration(), (int)args.size(), (long[])Longs.toArray(args));
    }

    @Override
    protected Long getBooleanVarDeclarationImpl(Long pLong) {
        return Native.getAppDecl((long)((Long)this.getEnv()), (long)pLong);
    }

    static boolean isOP(long z3context, long expr, int op) {
        if (!Native.isApp((long)z3context, (long)expr)) {
            return false;
        }
        long decl = Native.getAppDecl((long)z3context, (long)expr);
        return Native.getDeclKind((long)z3context, (long)decl) == op;
    }

    public long applyTactics(long z3context, Long pF, String ... pTactics) throws InterruptedException, SolverException {
        long overallResult = pF;
        for (String tactic : pTactics) {
            long tacticResult = this.applyTactic(z3context, overallResult, tactic);
            if (overallResult != pF) {
                Native.decRef((long)z3context, (long)overallResult);
            }
            overallResult = tacticResult;
        }
        return overallResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long applyTactic(long z3context, long pF, String tactic) throws InterruptedException {
        long result;
        long tacticObject = Native.mkTactic((long)z3context, (String)tactic);
        Native.tacticIncRef((long)z3context, (long)tacticObject);
        long goal = Native.mkGoal((long)z3context, (boolean)true, (boolean)false, (boolean)false);
        Native.goalIncRef((long)z3context, (long)goal);
        Native.goalAssert((long)z3context, (long)goal, (long)pF);
        try {
            result = Native.tacticApply((long)z3context, (long)tacticObject, (long)goal);
        }
        catch (Z3Exception exp) {
            throw this.handleZ3Exception(exp);
        }
        Native.applyResultIncRef((long)z3context, (long)result);
        try {
            long l = this.applyResultToAST(z3context, result);
            return l;
        }
        finally {
            Native.applyResultDecRef((long)z3context, (long)result);
            Native.goalDecRef((long)z3context, (long)goal);
            Native.tacticDecRef((long)z3context, (long)tacticObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long applyResultToAST(long z3context, long applyResult) {
        int subgoalsCount = Native.applyResultGetNumSubgoals((long)z3context, (long)applyResult);
        long[] goalFormulas = new long[subgoalsCount];
        for (int i = 0; i < subgoalsCount; ++i) {
            long subgoal = Native.applyResultGetSubgoal((long)z3context, (long)applyResult, (int)i);
            Native.goalIncRef((long)z3context, (long)subgoal);
            long subgoalAst = this.goalToAST(z3context, subgoal);
            Native.incRef((long)z3context, (long)subgoalAst);
            goalFormulas[i] = subgoalAst;
            Native.goalDecRef((long)z3context, (long)subgoal);
        }
        try {
            long l = goalFormulas.length == 1 ? goalFormulas[0] : Native.mkOr((long)z3context, (int)goalFormulas.length, (long[])goalFormulas);
            return l;
        }
        finally {
            for (int i = 0; i < subgoalsCount; ++i) {
                Native.decRef((long)z3context, (long)goalFormulas[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long goalToAST(long z3context, long goal) {
        int subgoalFormulasCount = Native.goalSize((long)z3context, (long)goal);
        long[] subgoalFormulas = new long[subgoalFormulasCount];
        for (int k = 0; k < subgoalFormulasCount; ++k) {
            long f = Native.goalFormula((long)z3context, (long)goal, (int)k);
            Native.incRef((long)z3context, (long)f);
            subgoalFormulas[k] = f;
        }
        try {
            long l = subgoalFormulas.length == 1 ? subgoalFormulas[0] : Native.mkAnd((long)z3context, (int)subgoalFormulas.length, (long[])subgoalFormulas);
            return l;
        }
        finally {
            for (int k = 0; k < subgoalFormulasCount; ++k) {
                Native.decRef((long)z3context, (long)subgoalFormulas[k]);
            }
        }
    }

    public void forceClose() {
        this.cleanupReferences();
        for (long ast : this.referenceMap.values()) {
            Native.decRef((long)((Long)this.getEnv()), (long)ast);
        }
    }
}

