/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3Model;

abstract class Z3AbstractProver<T>
implements BasicProverEnvironment<T> {
    protected final Z3FormulaCreator creator;
    protected final long z3context;
    protected boolean closed = false;

    protected Z3AbstractProver(Z3FormulaCreator creator) {
        this.creator = creator;
        this.z3context = (Long)creator.getEnv();
    }

    protected abstract long getZ3Model();

    @Override
    public Z3Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Z3Model.create(this.z3context, this.getZ3Model(), this.creator);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try (Z3Model model = this.getModel();){
            ImmutableList<Model.ValueAssignment> immutableList = model.modelToList();
            return immutableList;
        }
    }
}

