/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.visitors;

import com.google.common.collect.ImmutableSet;
import org.sosy_lab.solver.api.Formula;

public class TraversalProcess {
    public static final TraversalProcess CONTINUE = new TraversalProcess(TraversalType.CONTINUE_TYPE, (ImmutableSet<? extends Formula>)ImmutableSet.of());
    public static final TraversalProcess SKIP = new TraversalProcess(TraversalType.SKIP_TYPE, (ImmutableSet<? extends Formula>)ImmutableSet.of());
    public static final TraversalProcess ABORT = new TraversalProcess(TraversalType.ABORT_TYPE, (ImmutableSet<? extends Formula>)ImmutableSet.of());
    private final TraversalType type;
    private final ImmutableSet<? extends Formula> toTraverse;

    public static TraversalProcess custom(Iterable<? extends Formula> pToTraverse) {
        return new TraversalProcess(TraversalType.CUSTOM_TYPE, (ImmutableSet<? extends Formula>)ImmutableSet.copyOf(pToTraverse));
    }

    public static TraversalProcess custom(Formula pToTraverse) {
        return new TraversalProcess(TraversalType.CUSTOM_TYPE, (ImmutableSet<? extends Formula>)ImmutableSet.of((Object)pToTraverse));
    }

    private TraversalProcess(TraversalType pType, ImmutableSet<? extends Formula> pToTraverse) {
        this.type = pType;
        this.toTraverse = pToTraverse;
    }

    public TraversalType getType() {
        return this.type;
    }

    public boolean contains(Formula f) {
        if (this.type == TraversalType.CONTINUE_TYPE) {
            return true;
        }
        if (this.type == TraversalType.SKIP_TYPE || this.type == TraversalType.ABORT_TYPE) {
            return false;
        }
        assert (this.type == TraversalType.CUSTOM_TYPE);
        return this.toTraverse.contains((Object)f);
    }

    public static enum TraversalType {
        CONTINUE_TYPE,
        SKIP_TYPE,
        ABORT_TYPE,
        CUSTOM_TYPE;

    }
}

