/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.truth.TruthJUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class VariableNamesTest
extends SolverBasedTest0 {
    private static final String[] NAMES = new String[]{"as", "exists", "forall", "par", "let", "BINARY", "DECIMAL", "HEXADECIAML", "NUMERAL", "STRING", "define-fun", "declare", "get-model", "exit", " this is a quoted symbol ", " so is \n  this one ", " \" can occur too ", " af klj ^*0 asfe2 (&*)&(#^ $ > > >?\" \u2019]]984"};
    private static final String[] SPECIAL_NAMES = new String[]{"true", "false", "and", "or", "+", "-", "*", "=", "!=", "<", "<=", ">", ">=", "~", "!", ",", ".", ":", " ", "  ", "define-fun", "declare", "get-model", "exit", "(exit)", "select", "store", "|", "||", "|||", "|test", "|test|", "t|e|s|t", "(", ")", "[", "]", "{", "}", "[]", "\"", "''", "\"\"", "\\", "\n", "\t", "\u0000", "\u0001", "\u1234", "\u2e80", "| this is a quoted symbol |", " this is a quoted symbol ", "| so is \n  this one |", " so is \n  this one ", "| \" can occur too |", " \" can occur too ", "| af klj ^*0 asfe2 (&*)&(#^ $ > > >?\" \u2019]]984|", " af klj ^*0 asfe2 (&*)&(#^ $ > > >?\" \u2019]]984"};
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public String varname;

    @Parameterized.Parameters(name="{0} with varname {1}")
    public static List<Object[]> getAllCombinations() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (SolverContextFactory.Solvers solver : SolverContextFactory.Solvers.values()) {
            for (String varname : NAMES) {
                result.add(new Object[]{solver, varname});
            }
            if (SolverContextFactory.Solvers.SMTINTERPOL == solver) continue;
            for (String varname : SPECIAL_NAMES) {
                result.add(new Object[]{solver, varname});
            }
        }
        return result;
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testBoolVariable() {
        BooleanFormula var = this.bmgr.makeVariable(this.varname);
        String dump = this.mgr.dumpFormula(var).toString();
    }

    @Test
    public void testBoolVariableEscaping() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.SMTINTERPOL);
        BooleanFormula var = this.bmgr.makeVariable(this.varname);
        String dump = this.mgr.dumpFormula(var).toString();
        if (this.varname.equals(var.toString())) {
            BooleanFormula varFromString = this.bmgr.makeVariable(var.toString());
            this.assertThatFormula(var).isEquivalentTo(varFromString);
        } else {
            BooleanFormula varFromString = this.bmgr.makeVariable(var.toString());
            this.assertThatFormula(this.bmgr.xor(var, varFromString)).isSatisfiable();
            Assert.assertNotEquals((String)"name is escaped once, then the second call should escape it twice", (Object)this.varname, (Object)varFromString.toString());
            Assert.assertNotEquals((String)"name is escaped once, then the second call should escape it twice", (Object)this.mgr.dumpFormula(var).toString(), (Object)this.mgr.dumpFormula(varFromString).toString());
        }
    }

    @Test
    public void testIntVariable() {
        Object var = this.imgr.makeVariable(this.varname);
    }

    @Test
    public void testInvalidIntVariable() {
        Object var = this.imgr.makeVariable(this.varname);
    }

    @Test
    public void testInvalidRatVariable() {
        this.requireRationals();
        Object var = this.rmgr.makeVariable(this.varname);
    }

    @Test
    public void testBVVariable() {
        this.requireBitvectors();
        BitvectorFormula var = this.bvmgr.makeVariable(4, this.varname);
    }

    @Test
    public void testInvalidFloatVariable() {
        this.requireFloats();
        FloatingPointFormula var = this.fpmgr.makeVariable(this.varname, FormulaType.FloatingPointType.getSinglePrecisionFloatingPointType());
    }

    @Test
    public void testArrayVariable() {
        this.requireArrays();
        ArrayFormula var = this.amgr.makeArray(this.varname, FormulaType.IntegerType, FormulaType.IntegerType);
    }
}

