/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.basicimpl.tactics.UfElimination;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class UfEliminationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private UfElimination ackermannization;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setUp() throws Exception {
        this.ackermannization = new UfElimination(this.mgr);
    }

    @Test
    public void simpleTest() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable1, variable3}));
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable2, variable4}));
        BooleanFormula f = this.bmgr.xor(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4);
        BooleanFormula withOutUfs = this.ackermannization.eliminateUfs(f).getFormula();
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void nestedUfs() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf1Decl = this.fmgr.declareUF("uf1", FormulaType.IntegerType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        NumeralFormula.IntegerFormula uf1a = this.fmgr.callUF(uf1Decl, variable1, variable2);
        NumeralFormula.IntegerFormula uf1b = this.fmgr.callUF(uf1Decl, variable2, variable1);
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf2", FormulaType.BooleanType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new Formula[]{uf1a, variable3}));
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new Formula[]{uf1b, variable4}));
        BooleanFormula f = this.bmgr.xor(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4);
        BooleanFormula withOutUfs = this.ackermannization.eliminateUfs(f).getFormula();
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf1");
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf2");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void nestedUfs2() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        NumeralFormula.IntegerFormula variable5 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable5");
        NumeralFormula.IntegerFormula variable6 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable6");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        BooleanFormula v5EqualsV6 = this.imgr.equal(variable5, variable6);
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf1Decl = this.fmgr.declareUF("uf1", FormulaType.IntegerType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf2Decl = this.fmgr.declareUF("uf2", FormulaType.IntegerType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        NumeralFormula.IntegerFormula uf2a = this.fmgr.callUF(uf2Decl, variable1, variable2);
        NumeralFormula.IntegerFormula uf2b = this.fmgr.callUF(uf2Decl, variable1, variable2);
        NumeralFormula.IntegerFormula uf1a = this.fmgr.callUF(uf1Decl, variable1, uf2a);
        NumeralFormula.IntegerFormula uf1b = this.fmgr.callUF(uf1Decl, variable2, uf2b);
        NumeralFormula.IntegerFormula f1 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new Formula[]{uf1a, variable3}));
        NumeralFormula.IntegerFormula f2 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new Formula[]{uf1b, variable4}));
        BooleanFormula f = this.imgr.lessThan(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4, v5EqualsV6);
        BooleanFormula withOutUfs = this.ackermannization.eliminateUfs(f).getFormula();
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf1");
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf2");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void quantifierTest() {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable1, variable3}));
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable2, variable4}));
        BooleanFormula f = this.qmgr.exists(Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable1, variable2, variable3, variable4}), this.bmgr.equivalence(f1, f2));
        try {
            this.ackermannization.eliminateUfs(f);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void substitutionTest() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        FunctionDeclaration<BooleanFormula> ufDecl = this.fmgr.declareUF("uf", FormulaType.BooleanType, Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType}));
        BooleanFormula f1 = this.fmgr.callUF(ufDecl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable1, variable3}));
        BooleanFormula f2 = this.fmgr.callUF(ufDecl, Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{variable2, variable4}));
        BooleanFormula f = this.bmgr.or(f1, this.bmgr.not(f2));
        UfElimination.Result withOutUfs = this.ackermannization.eliminateUfs(f);
        Map<Formula, Formula> substitution = withOutUfs.getSubstitution();
        Truth.assertThat(substitution).hasSize(2);
        BiMap inverseSubstitution = HashBiMap.create(substitution).inverse();
        BooleanFormula revertedSubstitution = this.mgr.substitute(withOutUfs.getFormula(), (Map<? extends Formula, ? extends Formula>)inverseSubstitution);
        this.assertThatFormula(f).isEquivalentTo(revertedSubstitution);
    }
}

