/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.SolverBasedTest0;
import org.sosy_lab.solver.visitors.ExpectedFormulaVisitor;

@RunWith(value=Parameterized.class)
public class UFManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testDeclareAndCallUF() {
        ImmutableList names = ImmutableList.of((Object)"Func", (Object)"|Func|", (Object)"(Func)");
        for (String name : names) {
            NumeralFormula.IntegerFormula f = this.fmgr.declareAndCallUF(name, FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeNumber(1L)));
            FunctionDeclaration<?> declaration = this.getDeclaration(f);
            Truth.assertThat((String)declaration.getName()).isEqualTo((Object)name);
            Object f2 = this.mgr.makeApplication(declaration, new Formula[]{this.imgr.makeNumber(1L)});
            Truth.assertThat(f2).isEqualTo((Object)f);
        }
    }

    private FunctionDeclaration<?> getDeclaration(Formula f) {
        return (FunctionDeclaration)this.mgr.visit(f, new ExpectedFormulaVisitor<FunctionDeclaration<?>>(){

            @Override
            public FunctionDeclaration<?> visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                return functionDeclaration;
            }
        });
    }
}

