/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.truth.Truth;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.test.BooleanFormulaSubject;

@RunWith(value=Parameterized.class)
public class TranslateFormulaTest {
    private final LogManager logger = LogManager.createTestLogManager();
    private SolverContext from;
    private SolverContext to;
    private FormulaManager managerFrom;
    private FormulaManager managerTo;
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers translateFrom;
    @Parameterized.Parameter(value=1)
    public SolverContextFactory.Solvers translateTo;

    @Parameterized.Parameters
    public static Object[] getSolversProduct() {
        int len = SolverContextFactory.Solvers.values().length;
        SolverContextFactory.Solvers[][] combinations = new SolverContextFactory.Solvers[len * len][2];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                combinations[i * len + j][0] = SolverContextFactory.Solvers.values()[i];
                combinations[i * len + j][1] = SolverContextFactory.Solvers.values()[j];
            }
        }
        return combinations;
    }

    @Before
    public void initSolvers() throws Exception {
        Configuration empty = Configuration.builder().build();
        SolverContextFactory factory = new SolverContextFactory(empty, this.logger, ShutdownManager.create().getNotifier());
        this.from = factory.generateContext(this.translateFrom);
        this.to = factory.generateContext(this.translateTo);
        this.managerFrom = this.from.getFormulaManager();
        this.managerTo = this.to.getFormulaManager();
    }

    @After
    public void close() throws Exception {
        this.from.close();
        this.to.close();
    }

    @Test
    public void testDumpingAndParsing() throws Exception {
        BooleanFormula input = this.createTestFormula(this.managerFrom);
        String out = this.managerFrom.dumpFormula(input).toString();
        BooleanFormula parsed = this.managerTo.parse(out);
        this.assertThatFormula(this.createTestFormula(this.managerTo), this.to).isEquivalentTo(parsed);
    }

    @Test
    public void testTranslating() throws Exception {
        BooleanFormula input = this.createTestFormula(this.managerFrom);
        BooleanFormula parsed = this.managerTo.translateFrom(input, this.managerFrom);
        this.assertThatFormula(this.createTestFormula(this.managerTo), this.to).isEquivalentTo(parsed);
    }

    private BooleanFormula createTestFormula(FormulaManager mgr) {
        BooleanFormulaManager bfmgr = mgr.getBooleanFormulaManager();
        IntegerFormulaManager ifmgr = mgr.getIntegerFormulaManager();
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("z");
        BooleanFormula t = bfmgr.and(bfmgr.or(ifmgr.equal(x, y), ifmgr.equal(x, (NumeralFormula.IntegerFormula)ifmgr.makeNumber(2L))), bfmgr.or(ifmgr.equal(y, z), ifmgr.equal(z, (NumeralFormula.IntegerFormula)ifmgr.makeNumber(10L))));
        return t;
    }

    protected final BooleanFormulaSubject assertThatFormula(BooleanFormula formula, SolverContext context) {
        return (BooleanFormulaSubject)Truth.assert_().about(BooleanFormulaSubject.forSolver(context)).that((Object)formula);
    }
}

