/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.truth.TruthJUnit;
import java.util.Random;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.tactics.Tactic;
import org.sosy_lab.solver.test.Fuzzer;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class TimeoutTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testTacticTimeout() throws Exception {
        TruthJUnit.assume().withFailureMessage("Only Z3 has native tactics").that((Comparable)((Object)this.solverToUse())).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        Fuzzer fuzzer = new Fuzzer(this.mgr, new Random(0L));
        String msg = "ShutdownRequest";
        this.expectedEx.expect(InterruptedException.class);
        this.expectedEx.expectMessage(msg);
        BooleanFormula test = fuzzer.fuzz(20, 3);
        this.shutdownManager.requestShutdown(msg);
        this.mgr.applyTactic(test, Tactic.NNF);
    }

    @Test
    public void testProverTimeout() throws Exception {
        TruthJUnit.assume().withFailureMessage("Princess does not support interruption").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testBasicProverTimeout(() -> this.context.newProverEnvironment(new SolverContext.ProverOptions[0]));
    }

    @Test
    public void testInterpolationProverTimeout() throws Exception {
        TruthJUnit.assume().withFailureMessage("Princess does not support interruption").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testBasicProverTimeout(() -> this.context.newProverEnvironmentWithInterpolation());
    }

    @Test
    public void testOptimizationProverTimeout() throws Exception {
        this.requireOptimization();
        this.testBasicProverTimeout(() -> this.context.newOptimizationProverEnvironment());
    }

    private void testBasicProverTimeout(Supplier<BasicProverEnvironment<?>> proverConstructor) throws Exception {
        Fuzzer f = new Fuzzer(this.mgr, new Random(0L));
        this.expectedEx.expect(InterruptedException.class);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(1L);
                    TimeoutTest.this.shutdownManager.requestShutdown("Shutdown Request");
                }
                catch (InterruptedException pE) {
                    throw new UnsupportedOperationException("Unexpected interrupt");
                }
            }
        };
        try (BasicProverEnvironment<?> pe = proverConstructor.get();){
            pe.push(f.fuzz(10000, 100));
            t.start();
            pe.isUnsat();
        }
    }
}

