/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.Fuzzer;
import org.sosy_lab.solver.test.SolverBasedTest0;
import org.sosy_lab.solver.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.solver.visitors.BooleanFormulaVisitor;
import org.sosy_lab.solver.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.solver.visitors.DefaultFormulaVisitor;
import org.sosy_lab.solver.visitors.FormulaTransformationVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

@RunWith(value=Parameterized.class)
public class SolverVisitorTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void booleanIdVisit() {
        BooleanFormula t = this.bmgr.makeBoolean(true);
        BooleanFormula f = this.bmgr.makeBoolean(false);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula y = this.bmgr.makeVariable("y");
        BooleanFormula z = this.bmgr.makeVariable("z");
        BooleanFormula and = this.bmgr.and(x, y);
        BooleanFormula or = this.bmgr.or(x, y);
        BooleanFormula ite = this.bmgr.ifThenElse(x, and, or);
        BooleanFormula impl = this.bmgr.implication(z, y);
        BooleanFormula eq = this.bmgr.equivalence(t, y);
        BooleanFormula not = this.bmgr.not(eq);
        for (BooleanFormula bf : ImmutableList.of((Object)t, (Object)f, (Object)x, (Object)y, (Object)z, (Object)and, (Object)or, (Object)ite, (Object)impl, (Object)eq, (Object)not)) {
            BooleanFormulaTransformationVisitor identityVisitor = new BooleanFormulaTransformationVisitor(this.mgr){};
            this.assertThatFormula(this.bmgr.visit(bf, identityVisitor)).isEqualTo(bf);
        }
    }

    @Test
    public void booleanIdVisitWithAtoms() {
        NumeralFormula.IntegerFormula n12 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(12L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
        NumeralFormula.IntegerFormula sum = (NumeralFormula.IntegerFormula)this.imgr.add(a, b);
        NumeralFormula.IntegerFormula diff = (NumeralFormula.IntegerFormula)this.imgr.subtract(a, b);
        NumeralFormula.IntegerFormula neg = (NumeralFormula.IntegerFormula)this.imgr.negate(a);
        BooleanFormula eq = this.imgr.equal(n12, a);
        NumeralFormula.IntegerFormula ite = this.bmgr.ifThenElse(eq, sum, diff);
        for (NumeralFormula.IntegerFormula f : ImmutableList.of((Object)a, (Object)b, (Object)n12, (Object)neg, (Object)ite)) {
            BooleanFormulaTransformationVisitor identityVisitor = new BooleanFormulaTransformationVisitor(this.mgr){};
            BooleanFormula bf = this.imgr.equal(n12, f);
            this.assertThatFormula(this.bmgr.visit(bf, identityVisitor)).isEqualTo(bf);
        }
    }

    @Test
    public void testFormulaVisitor() {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
        BooleanFormula f = this.bmgr.or(this.imgr.equal(z, (NumeralFormula.IntegerFormula)this.imgr.add(x, y)), this.imgr.equal(x, (NumeralFormula.IntegerFormula)this.imgr.add(z, y)));
        final HashSet usedVariables = new HashSet();
        DefaultFormulaVisitor<TraversalProcess> nameExtractor = new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFreeVariable(Formula f, String name) {
                usedVariables.add(name);
                return TraversalProcess.CONTINUE;
            }
        };
        this.mgr.visitRecursively(f, (FormulaVisitor<TraversalProcess>)nameExtractor);
        Truth.assertThat(usedVariables).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"x", "y", "z"}));
    }

    @Test
    public void testBooleanFormulaQuantifierHandling() throws Exception {
        this.requireQuantifiers();
        TruthJUnit.assume().withFailureMessage("Princess does not support quantifier over boolean variables").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula constraint = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)x), x);
        this.assertThatFormula(constraint).isUnsatisfiable();
        BooleanFormula newConstraint = this.bmgr.visit(constraint, new BooleanFormulaTransformationVisitor(this.mgr){});
        this.assertThatFormula(newConstraint).isUnsatisfiable();
    }

    @Test
    public void testVisitingTrue() throws Exception {
        BooleanFormula t = this.bmgr.makeBoolean(true);
        final ArrayList containsTrue = new ArrayList();
        this.mgr.visitRecursively(t, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitConstant(Formula f, Object o) {
                if (f.equals(SolverVisitorTest.this.bmgr.makeBoolean(true))) {
                    containsTrue.add(true);
                }
                return TraversalProcess.CONTINUE;
            }
        });
        Truth.assertThat(containsTrue).isNotEmpty();
    }

    @Test
    public void testCorrectFunctionNames() throws Exception {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula ab = this.bmgr.and(a, b);
        final HashSet found = new HashSet();
        this.mgr.visitRecursively(ab, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                found.add(functionDeclaration.getName());
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFreeVariable(Formula f, String name) {
                found.add(name);
                return TraversalProcess.CONTINUE;
            }
        });
        Truth.assertThat(found).containsAllOf((Object)"a", (Object)"b", new Object[0]);
        Truth.assertThat(found).hasSize(3);
        Truth.assertThat(found).doesNotContain((Object)ab.toString());
    }

    @Test
    public void recursiveTransformationVisitorTest() throws Exception {
        BooleanFormula f = this.bmgr.or(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("z"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)));
        BooleanFormula transformed = this.mgr.transformRecursively(f, new FormulaTransformationVisitor(this.mgr){

            @Override
            public Formula visitFreeVariable(Formula f, String name) {
                return SolverVisitorTest.this.mgr.makeVariable(SolverVisitorTest.this.mgr.getFormulaType(f), name + "'");
            }
        });
        this.assertThatFormula(transformed).isEquivalentTo(this.bmgr.or(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x'"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y'")), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("z'"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L))));
    }

    @Test
    public void booleanRecursiveTraversalTest() throws Exception {
        BooleanFormula f = this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("x"), this.bmgr.makeVariable("y")), this.bmgr.and((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.makeVariable("z"), (Object)this.bmgr.makeVariable("d"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("gg"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)))));
        final HashSet foundVars = new HashSet();
        this.bmgr.visitRecursively(f, (BooleanFormulaVisitor<TraversalProcess>)new DefaultBooleanFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault() {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> funcDecl) {
                if (funcDecl.getKind() == FunctionDeclarationKind.VAR) {
                    foundVars.add(funcDecl.getName());
                }
                return TraversalProcess.CONTINUE;
            }
        });
        Truth.assertThat(foundVars).containsExactly(new Object[]{"x", "y", "z", "d"});
    }

    @Test
    public void testTransformationInsideQuantifiers() throws Exception {
        this.requireQuantifiers();
        TruthJUnit.assume().withFailureMessage("Princess does not support quantifier over boolean variables").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        List<BooleanFormula> usedVars = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f").stream().map(var -> this.bmgr.makeVariable((String)var)).collect(Collectors.toList());
        Fuzzer fuzzer = new Fuzzer(this.mgr, new Random(0L));
        ImmutableList quantifiedVars = ImmutableList.of((Object)this.bmgr.makeVariable("a"));
        BooleanFormula body = fuzzer.fuzz(30, usedVars.toArray(new BooleanFormula[usedVars.size()]));
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)quantifiedVars, body);
        BooleanFormula transformed = this.bmgr.transformRecursively(f, new BooleanFormulaTransformationVisitor(this.mgr){

            @Override
            public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
                if (decl.getKind() == FunctionDeclarationKind.VAR) {
                    return SolverVisitorTest.this.bmgr.makeVariable(decl.getName().toUpperCase());
                }
                return pAtom;
            }
        });
        Truth.assertThat((Boolean)this.mgr.extractVariables(transformed).keySet().stream().allMatch(pS -> pS.equals(pS.toUpperCase()))).isTrue();
    }
}

