/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverInterpolationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    @Parameterized.Parameters(name="{0}")
    public static SolverContextFactory.Solvers[] getAllCombinations() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    private <T> InterpolatingProverEnvironment<T> newEnvironmentForTest() {
        return this.context.newProverEnvironmentWithInterpolation();
    }

    @Test
    public <T> void simpleInterpolation() throws Exception {
        this.requireInterpolation();
        try (InterpolatingProverEnvironment<T> prover = this.newEnvironmentForTest();){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
            NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
            BooleanFormula f1 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.multiply((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), x));
            BooleanFormula f2 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.multiply(z, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L))));
            prover.push(f1);
            T id2 = prover.push(f2);
            boolean check = prover.isUnsat();
            ((BooleanSubject)Truth.assertThat((Boolean)check).named("formulas must be contradicting")).isTrue();
            prover.getInterpolant(Collections.singletonList(id2));
        }
    }

    @Test
    public <T> void emptyInterpolationGroup() throws SolverException, InterruptedException {
        this.requireInterpolation();
        try (InterpolatingProverEnvironment<T> prover = this.newEnvironmentForTest();){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
            NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
            BooleanFormula f1 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.multiply((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), x));
            BooleanFormula f2 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.multiply(z, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L))));
            T id1 = prover.push(f1);
            T id2 = prover.push(f2);
            Truth.assertThat((Boolean)prover.isUnsat()).isTrue();
            BooleanFormula emptyB = prover.getInterpolant((List<T>)ImmutableList.of(id1, id2));
            Truth.assertThat((Boolean)this.bmgr.isFalse(emptyB)).isTrue();
            BooleanFormula emptyA = prover.getInterpolant((List<T>)ImmutableList.of());
            Truth.assertThat((Boolean)this.bmgr.isTrue(emptyA)).isTrue();
        }
    }

    @Test
    public <T> void binaryInterpolation() throws SolverException, InterruptedException {
        this.requireInterpolation();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        T TA = stack.push(A);
        T TB = stack.push(B);
        T TC = stack.push(C);
        T TD = stack.push(D);
        this.assertThatEnvironment(stack).isUnsatisfiable();
        BooleanFormula itp = stack.getInterpolant((List<T>)ImmutableList.of());
        BooleanFormula itpA = stack.getInterpolant((List<T>)ImmutableList.of(TA));
        BooleanFormula itpAB = stack.getInterpolant((List<T>)ImmutableList.of(TA, TB));
        BooleanFormula itpABC = stack.getInterpolant((List<T>)ImmutableList.of(TA, TB, TC));
        BooleanFormula itpD = stack.getInterpolant((List<T>)ImmutableList.of(TD));
        BooleanFormula itpDC = stack.getInterpolant((List<T>)ImmutableList.of(TD, TC));
        BooleanFormula itpDCB = stack.getInterpolant((List<T>)ImmutableList.of(TD, TC, TB));
        BooleanFormula itpABCD = stack.getInterpolant((List<T>)ImmutableList.of(TA, TB, TC, TD));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        Truth.assertThat((Object)this.bmgr.makeBoolean(true)).isEqualTo((Object)itp);
        Truth.assertThat((Object)this.bmgr.makeBoolean(false)).isEqualTo((Object)itpABCD);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D), (List<BooleanFormula>)ImmutableList.of((Object)itpA, (Object)itpAB, (Object)itpABC));
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)D, (Object)C, (Object)B, (Object)A), (List<BooleanFormula>)ImmutableList.of((Object)itpD, (Object)itpDC, (Object)itpDCB));
    }

    @Test
    public <T> void binaryInterpolation1() throws SolverException, InterruptedException {
        this.requireInterpolation();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.bmgr.makeBoolean(false);
        BooleanFormula B = this.bmgr.makeBoolean(false);
        T TA = stack.push(A);
        T TB = stack.push(B);
        this.assertThatEnvironment(stack).isUnsatisfiable();
        BooleanFormula itp0 = stack.getInterpolant((List<T>)ImmutableList.of());
        BooleanFormula itpA = stack.getInterpolant((List<T>)ImmutableList.of(TA));
        BooleanFormula itpB = stack.getInterpolant((List<T>)ImmutableList.of(TA));
        BooleanFormula itpAB = stack.getInterpolant((List<T>)ImmutableList.of(TA, TB));
        stack.pop();
        stack.pop();
        Truth.assertThat((Object)this.bmgr.makeBoolean(true)).isEqualTo((Object)itp0);
        Truth.assertThat((Object)this.bmgr.makeBoolean(false)).isEqualTo((Object)itpAB);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B), (List<BooleanFormula>)ImmutableList.of((Object)itpA));
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)B, (Object)A), (List<BooleanFormula>)ImmutableList.of((Object)itpB));
    }

    private void requireSequentialItp() {
        this.requireInterpolation();
        TruthJUnit.assume().withFailureMessage("Solver does not support sequential interpolation.").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
    }

    private void requireTreeItp() {
        this.requireInterpolation();
        TruthJUnit.assume().withFailureMessage("Solver does not support tree-interpolation.").that((Comparable)((Object)this.solver)).isAnyOf((Object)SolverContextFactory.Solvers.Z3, (Object)SolverContextFactory.Solvers.SMTINTERPOL, new Object[0]);
    }

    @Test
    public <T> void sequentialInterpolation() throws SolverException, InterruptedException {
        this.requireSequentialItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(A)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(B)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(C)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(D)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps1 = stack.getSeqInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TB, (Object)TC, (Object)TD));
        List<BooleanFormula> itps2 = stack.getSeqInterpolants((List<Set<T>>)ImmutableList.of((Object)TD, (Object)TC, (Object)TB, (Object)TA));
        List<BooleanFormula> itps3 = stack.getSeqInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TC, (Object)TB, (Object)TD));
        List<BooleanFormula> itps4 = stack.getSeqInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TA, (Object)TA, (Object)TB, (Object)TC, (Object)TD, (Object)TD));
        List<BooleanFormula> itps5 = stack.getSeqInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TA, (Object)TB, (Object)TC, (Object)TD, (Object)TA, (Object)TD));
        List<BooleanFormula> itps6 = stack.getSeqInterpolants((List<Set<T>>)ImmutableList.of((Object)TB, (Object)TC, (Object)TD, (Object)TA, (Object)TA, (Object)TA, (Object)TD));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D), itps1);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)D, (Object)C, (Object)B, (Object)A), itps2);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)C, (Object)B, (Object)D), itps3);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)A, (Object)A, (Object)C, (Object)B, (Object)D, (Object)D), itps4);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)A, (Object)B, (Object)C, (Object)D, (Object)A, (Object)D), itps5);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)B, (Object)C, (Object)D, (Object)A, (Object)A, (Object)A, (Object)D), itps6);
    }

    @Test
    public <T> void treeInterpolation() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, d);
        BooleanFormula E = this.imgr.equal(d, zero);
        this.testTreeInterpolants0(stack, A, B, C, D, E);
        this.testTreeInterpolants0(stack, A, B, C, E, D);
        this.testTreeInterpolants0(stack, A, B, D, C, E);
        this.testTreeInterpolants0(stack, A, B, D, E, C);
        this.testTreeInterpolants0(stack, A, B, E, C, D);
        this.testTreeInterpolants0(stack, A, B, E, D, C);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, A, A);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, A, B);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, B, A);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, B, A, A);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, B, B);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, B, B, B);
        this.testTreeInterpolants1(stack, A, B, C, D, E);
        this.testTreeInterpolants1(stack, A, B, C, E, D);
        this.testTreeInterpolants1(stack, A, B, D, C, E);
        this.testTreeInterpolants1(stack, A, B, D, E, C);
        this.testTreeInterpolants1(stack, A, B, E, C, D);
        this.testTreeInterpolants1(stack, A, B, E, D, C);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, A, A);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, A, B);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, B, A);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, B, A, A);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, B, B);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, B, B, B);
        this.testTreeInterpolants2(stack, A, B, C, D, E);
        this.testTreeInterpolants2(stack, A, B, C, E, D);
        this.testTreeInterpolants2(stack, A, B, D, C, E);
        this.testTreeInterpolants2(stack, A, B, D, E, C);
        this.testTreeInterpolants2(stack, A, B, E, C, D);
        this.testTreeInterpolants2(stack, A, B, E, D, C);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, A, A);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, A, B);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, B, A);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, B, A, A);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, B, B);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, B, B, B);
    }

    private <T> void testTreeInterpolants0(InterpolatingProverEnvironment<T> stack, BooleanFormula pA, BooleanFormula pB, BooleanFormula pC, BooleanFormula pD, BooleanFormula pE) throws SolverException, InterruptedException {
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(pA)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(pB)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(pC)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(pD)});
        HashSet TE = Sets.newHashSet((Object[])new Object[]{stack.push(pE)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TB, (Object)TD, (Object)TE, (Object)TC), new int[]{0, 0, 2, 2, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, pA, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), pB), itps.get(1));
        this.checkImplies(stack, pD, itps.get(2));
        this.checkImplies(stack, this.bmgr.and(itps.get(2), pE), itps.get(3));
        this.checkImplies(stack, this.bmgr.and(itps.get(1), itps.get(3), pC), this.bmgr.makeBoolean(false));
    }

    private <T> void testTreeInterpolants1(InterpolatingProverEnvironment<T> stack, BooleanFormula pA, BooleanFormula pB, BooleanFormula pC, BooleanFormula pD, BooleanFormula pE) throws SolverException, InterruptedException {
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(pA)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(pB)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(pC)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(pD)});
        HashSet TE = Sets.newHashSet((Object[])new Object[]{stack.push(pE)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TB, (Object)TC, (Object)TD, (Object)TE), new int[]{0, 1, 2, 3, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, pA, itps.get(0));
        this.checkImplies(stack, pB, itps.get(1));
        this.checkImplies(stack, pC, itps.get(2));
        this.checkImplies(stack, pD, itps.get(3));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), itps.get(1), itps.get(2), itps.get(3), pE), this.bmgr.makeBoolean(false));
    }

    private <T> void testTreeInterpolants2(InterpolatingProverEnvironment<T> stack, BooleanFormula pA, BooleanFormula pB, BooleanFormula pC, BooleanFormula pD, BooleanFormula pE) throws SolverException, InterruptedException {
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(pA)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(pB)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(pC)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(pD)});
        HashSet TE = Sets.newHashSet((Object[])new Object[]{stack.push(pE)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TB, (Object)TC, (Object)TD, (Object)TE), new int[]{0, 0, 0, 0, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, pA, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), pB), itps.get(1));
        this.checkImplies(stack, this.bmgr.and(itps.get(1), pC), itps.get(2));
        this.checkImplies(stack, this.bmgr.and(itps.get(2), pD), itps.get(3));
        this.checkImplies(stack, this.bmgr.and(itps.get(3), pE), this.bmgr.makeBoolean(false));
    }

    @Test
    public <T> void treeInterpolation2() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula five = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        NumeralFormula.IntegerFormula e = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("e" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula R1 = this.imgr.equal(b, c);
        BooleanFormula C = this.imgr.equal(c, (NumeralFormula.IntegerFormula)this.imgr.add(d, one));
        BooleanFormula R2 = this.imgr.equal(d, e);
        BooleanFormula D = this.imgr.equal(e, five);
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(A)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(B)});
        HashSet TR1 = Sets.newHashSet((Object[])new Object[]{stack.push(R1)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(C)});
        HashSet TR2 = Sets.newHashSet((Object[])new Object[]{stack.push(R2)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(D)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants((List<Set<T>>)ImmutableList.of((Object)TA, (Object)TB, (Object)TC, (Object)TR1, (Object)TD, (Object)TR2), new int[]{0, 0, 2, 0, 4, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, A, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), B), itps.get(1));
        this.checkImplies(stack, C, itps.get(2));
        this.checkImplies(stack, this.bmgr.and(itps.get(1), itps.get(2), R1), itps.get(3));
        this.checkImplies(stack, D, itps.get(4));
        this.checkImplies(stack, this.bmgr.and(itps.get(3), itps.get(4), R2), this.bmgr.makeBoolean(false));
    }

    private void checkItpSequence(InterpolatingProverEnvironment<?> stack, List<BooleanFormula> formulas, List<BooleanFormula> itps) throws SolverException, InterruptedException {
        assert (formulas.size() - 1 == itps.size()) : "there should be N-1 interpolants for N formulas";
        this.checkImplies(stack, formulas.get(0), itps.get(0));
        for (int i = 1; i < formulas.size() - 1; ++i) {
            this.checkImplies(stack, this.bmgr.and(itps.get(i - 1), formulas.get(i)), itps.get(i));
        }
        this.checkImplies(stack, this.bmgr.and((BooleanFormula)Iterables.getLast(itps), (BooleanFormula)Iterables.getLast(formulas)), this.bmgr.makeBoolean(false));
    }

    private void checkImplies(BasicProverEnvironment<?> stack, BooleanFormula a, BooleanFormula b) throws SolverException, InterruptedException {
        stack.push(this.bmgr.or(this.bmgr.not(a), b));
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
    }
}

