/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.ProverEnvironment;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class ProverEnvironmentSubject
extends Subject<ProverEnvironmentSubject, BasicProverEnvironment<?>> {
    private ProverEnvironmentSubject(FailureStrategy pFailureStrategy, BasicProverEnvironment<?> pStack) {
        super(pFailureStrategy, pStack);
    }

    public static SubjectFactory<ProverEnvironmentSubject, BasicProverEnvironment<?>> proverEnvironment() {
        return new SubjectFactory<ProverEnvironmentSubject, BasicProverEnvironment<?>>(){

            public ProverEnvironmentSubject getSubject(FailureStrategy pFs, BasicProverEnvironment<?> pFormula) {
                return new ProverEnvironmentSubject(pFs, pFormula);
            }
        };
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (((BasicProverEnvironment)this.getSubject()).isUnsat()) {
            return;
        }
        try (Model model = ((BasicProverEnvironment)this.getSubject()).getModel();){
            this.failWithBadResults("is", "unsatisfiable", "has counterexample", model);
        }
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        if (!((BasicProverEnvironment)this.getSubject()).isUnsat()) {
            return;
        }
        if (this.getSubject() instanceof ProverEnvironment) {
            try {
                List<BooleanFormula> unsatCore = ((ProverEnvironment)this.getSubject()).getUnsatCore();
                if (!unsatCore.isEmpty()) {
                    this.failWithBadResults("is", "satisfiable", "has unsat core", unsatCore);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.fail("is", "satisfiable");
    }
}

