/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class BooleanFormulaSubject
extends Subject<BooleanFormulaSubject, BooleanFormula> {
    private final SolverContext context;

    private BooleanFormulaSubject(FailureStrategy pFailureStrategy, BooleanFormula pFormula, SolverContext pMgr) {
        super(pFailureStrategy, (Object)pFormula);
        this.context = (SolverContext)Preconditions.checkNotNull((Object)pMgr);
    }

    public static SubjectFactory<BooleanFormulaSubject, BooleanFormula> forSolver(final SolverContext context) {
        return new SubjectFactory<BooleanFormulaSubject, BooleanFormula>(){

            public BooleanFormulaSubject getSubject(FailureStrategy pFs, BooleanFormula pFormula) {
                return new BooleanFormulaSubject(pFs, pFormula, context);
            }
        };
    }

    private void checkIsUnsat(BooleanFormula subject, String verb, Object expected) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(subject);
            if (prover.isUnsat()) {
                return;
            }
            try (Model model = prover.getModel();){
                this.failWithBadResults(verb, expected, "has counterexample", model);
            }
        }
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (this.context.getFormulaManager().getBooleanFormulaManager().isTrue((BooleanFormula)this.getSubject())) {
            this.failWithBadResults("is", "unsatisfiable", "is", "trivially satisfiable");
        }
        this.checkIsUnsat((BooleanFormula)this.getSubject(), "is", "unsatisfiable");
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        if (this.context.getFormulaManager().getBooleanFormulaManager().isFalse((BooleanFormula)this.getSubject())) {
            this.failWithBadResults("is", "satisfiable", "is", "trivially unsatisfiable");
        }
        try (ProverEnvironment prover = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            prover.push((BooleanFormula)this.getSubject());
            if (!prover.isUnsat()) {
                return;
            }
        }
        try {
            prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            var2_3 = null;
            try {
                List<BooleanFormula> unsatCore = prover.getUnsatCore();
                if (unsatCore.isEmpty() || unsatCore.size() == 1 && ((BooleanFormula)this.getSubject()).equals(unsatCore.get(0))) {
                    this.fail("is", "satisfiable");
                } else {
                    this.failWithBadResults("is", "satisfiable", "has unsat core", unsatCore);
                }
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (prover != null) {
                    if (var2_3 != null) {
                        try {
                            prover.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        prover.close();
                    }
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            this.fail("is", "satisfiable");
        }
    }

    public void isTautological() throws SolverException, InterruptedException {
        this.isSatisfiable();
        this.checkIsUnsat(this.context.getFormulaManager().getBooleanFormulaManager().not((BooleanFormula)this.getSubject()), "is", "tautological");
    }

    public void isEquivalentTo(BooleanFormula expected) throws SolverException, InterruptedException {
        if (((BooleanFormula)this.getSubject()).equals(expected)) {
            return;
        }
        BooleanFormula f = this.context.getFormulaManager().getBooleanFormulaManager().xor((BooleanFormula)this.getSubject(), expected);
        this.checkIsUnsat(f, "is equivalent to", expected);
    }

    public void isEquisatisfiableTo(BooleanFormula other) throws SolverException, InterruptedException {
        BooleanFormulaManager bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.checkIsUnsat(bfmgr.and((BooleanFormula)this.getSubject(), bfmgr.not(other)), " is not equisatisfiable with ", other);
    }

    public void implies(BooleanFormula expected) throws SolverException, InterruptedException {
        if (((BooleanFormula)this.getSubject()).equals(expected)) {
            return;
        }
        BooleanFormulaManager bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        BooleanFormula implication = bmgr.or(bmgr.not((BooleanFormula)this.getSubject()), expected);
        this.checkIsUnsat(bmgr.not(implication), "implies", expected);
    }
}

