/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class BooleanFormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testConjunctionArgsExtractionEmpty() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.makeBoolean(true);
        Truth.assertThat(this.bmgr.toConjunctionArgs(input, false)).isEmpty();
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testConjunctionArgsExtraction() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.and(this.bmgr.makeVariable("a"), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
        Truth.assertThat(this.bmgr.toConjunctionArgs(input, false)).isEqualTo((Object)ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"))));
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testConjunctionArgsExtractionRecursive() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.and(this.bmgr.makeVariable("a"), this.bmgr.makeBoolean(true), this.bmgr.and(this.bmgr.makeVariable("b"), this.bmgr.makeVariable("c"), this.bmgr.and(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), this.bmgr.makeVariable("d"), this.bmgr.or(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f")))), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
        Truth.assertThat(this.bmgr.toConjunctionArgs(input, true)).isEqualTo((Object)ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), (Object)this.bmgr.makeVariable("d"), (Object[])new BooleanFormula[]{this.bmgr.or(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f"))}));
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, true))).isEquivalentTo(input);
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testDisjunctionArgsExtractionEmpty() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.makeBoolean(false);
        Truth.assertThat(this.bmgr.toDisjunctionArgs(input, false)).isEmpty();
        this.assertThatFormula(this.bmgr.or(this.bmgr.toDisjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testDisjunctionArgsExtraction() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.or(this.bmgr.makeVariable("a"), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
        Truth.assertThat(this.bmgr.toDisjunctionArgs(input, false)).isEqualTo((Object)ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"))));
        this.assertThatFormula(this.bmgr.or(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testDisjunctionArgsExtractionRecursive() throws SolverException, InterruptedException {
        BooleanFormula input = this.bmgr.or(this.bmgr.makeVariable("a"), this.bmgr.makeBoolean(false), this.bmgr.or(this.bmgr.makeVariable("b"), this.bmgr.makeVariable("c"), this.bmgr.or(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), this.bmgr.makeVariable("d"), this.bmgr.and(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f")))), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
        Truth.assertThat(this.bmgr.toDisjunctionArgs(input, true)).isEqualTo((Object)ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), (Object)this.bmgr.makeVariable("d"), (Object[])new BooleanFormula[]{this.bmgr.and(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f"))}));
        this.assertThatFormula(this.bmgr.or(this.bmgr.toDisjunctionArgs(input, true))).isEquivalentTo(input);
        this.assertThatFormula(this.bmgr.or(this.bmgr.toDisjunctionArgs(input, false))).isEquivalentTo(input);
    }
}

