/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.smtinterpol.SmtInterpolBasicProver;
import org.sosy_lab.solver.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaManager;

class SmtInterpolTheoremProver
extends SmtInterpolBasicProver<Void, Term>
implements ProverEnvironment {
    private final SmtInterpolFormulaManager mgr;
    private final SmtInterpolEnvironment env;
    private final Map<String, Term> annotatedTerms;
    private final FormulaCreator<Term, Sort, SmtInterpolEnvironment, FunctionSymbol> creator;
    private final boolean generateUnsatCores;

    SmtInterpolTheoremProver(SmtInterpolFormulaManager pMgr, FormulaCreator<Term, Sort, SmtInterpolEnvironment, FunctionSymbol> pCreator, Set<SolverContext.ProverOptions> options) {
        super(pMgr);
        this.mgr = pMgr;
        this.env = this.mgr.createEnvironment();
        this.creator = pCreator;
        Preconditions.checkNotNull((Object)this.env);
        this.annotatedTerms = new HashMap<String, Term>();
        this.generateUnsatCores = options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.push();
        Preconditions.checkState((boolean)this.annotatedTerms.isEmpty(), (Object)"Empty environment required for UNSAT core over assumptions.");
        for (BooleanFormula assumption : assumptions) {
            String termName = SmtInterpolTheoremProver.generateTermName();
            Term t = (Term)this.mgr.extractInfo(assumption);
            Term annotated = this.env.annotate(t, new Annotation(":named", (Object)termName));
            this.annotatedTerms.put(termName, t);
            this.env.assertTerm(annotated);
        }
        if (!this.isUnsat()) {
            return Optional.empty();
        }
        List<BooleanFormula> out = this.getUnsatCore();
        this.pop();
        return Optional.of(out);
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term t = (Term)this.mgr.extractInfo(constraint);
        if (this.generateUnsatCores) {
            String termName = SmtInterpolTheoremProver.generateTermName();
            Term annotated = this.env.annotate(t, new Annotation(":named", (Object)termName));
            this.annotatedTerms.put(termName, t);
            this.env.assertTerm(annotated);
        } else {
            this.env.assertTerm(t);
        }
        ((List)this.assertedFormulas.peek()).add(t);
        return null;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term[] terms = this.env.getUnsatCore();
        return Lists.transform(Arrays.asList(terms), input -> this.creator.encapsulateBoolean(this.annotatedTerms.get(input.toString())));
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term[] importantTerms = new Term[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            importantTerms[i++] = (Term)this.mgr.extractInfo(impF);
        }
        for (Term[] model : this.env.checkAllSat(importantTerms)) {
            callback.apply(Lists.transform(Arrays.asList(model), this.creator::encapsulateBoolean));
        }
        return callback.getResult();
    }

    @Override
    protected Collection<Term> getAssertedTerms() {
        ArrayList<Term> result = new ArrayList<Term>();
        this.assertedFormulas.forEach(result::addAll);
        return result;
    }
}

