/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.AbstractModel;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaCreator;

class SmtInterpolModel
extends AbstractModel.CachingAbstractModel<Term, Sort, SmtInterpolEnvironment> {
    private final Model model;
    private final ImmutableList<Term> assertedTerms;
    private final SmtInterpolFormulaCreator formulaCreator;

    SmtInterpolModel(Model pModel, FormulaCreator<Term, Sort, SmtInterpolEnvironment, ?> pCreator, Collection<Term> assertedTerms) {
        super(pCreator);
        this.formulaCreator = (SmtInterpolFormulaCreator)pCreator;
        this.model = pModel;
        this.assertedTerms = ImmutableList.copyOf(assertedTerms);
    }

    @Override
    @Nullable
    public Object evaluateImpl(Term f) {
        Term out = this.model.evaluate(f);
        return this.getValue(out);
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> modelToList() {
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (Term t : this.assertedTerms) {
            for (Map.Entry<String, Term> entry : this.creator.extractVariablesAndUFs(t, true).entrySet()) {
                if (entry.getValue().getSort().isArraySort()) {
                    assignments.addAll(this.getArrayAssignment(entry.getKey(), entry.getValue(), entry.getValue(), Collections.emptyList()));
                    continue;
                }
                assignments.add((Object)this.getAssignment(entry.getKey(), (ApplicationTerm)entry.getValue()));
            }
        }
        return assignments.build().asList();
    }

    private Collection<Model.ValueAssignment> getArrayAssignment(String symbol, Term key, Term array, List<Object> upperIndices) {
        assert (array.getSort().isArraySort());
        ArrayList<Model.ValueAssignment> assignments = new ArrayList<Model.ValueAssignment>();
        Term evaluation = this.model.evaluate(array);
        while (evaluation instanceof ApplicationTerm) {
            ApplicationTerm arrayEval = (ApplicationTerm)evaluation;
            FunctionSymbol funcDecl = arrayEval.getFunction();
            Term[] params = arrayEval.getParameters();
            if (!funcDecl.isIntern() || !"store".equals(funcDecl.getName())) break;
            Term index = params[1];
            Term content = params[2];
            ArrayList innerIndices = Lists.newArrayList(upperIndices);
            innerIndices.add(this.evaluateImpl(index));
            Term select = ((SmtInterpolEnvironment)this.creator.getEnv()).term("select", key, index);
            if (content.getSort().isArraySort()) {
                assignments.addAll(this.getArrayAssignment(symbol, select, content, innerIndices));
            } else {
                assignments.add(new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), symbol, this.evaluateImpl(content), innerIndices));
            }
            evaluation = params[0];
        }
        return assignments;
    }

    private Model.ValueAssignment getAssignment(String key, ApplicationTerm term) {
        Formula fKey = this.creator.encapsulateWithTypeOf(term);
        Object fValue = this.evaluateImpl((Term)term);
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (Term param : term.getParameters()) {
            argumentInterpretation.add(this.evaluateImpl(param));
        }
        return new Model.ValueAssignment(fKey, key, fValue, argumentInterpretation);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    private Object getValue(Term value) {
        FormulaType<?> type = this.creator.getFormulaType(value);
        if (type.isBooleanType()) {
            return value.getTheory().mTrue == value;
        }
        if (value instanceof ConstantTerm && ((ConstantTerm)value).getValue() instanceof de.uni_freiburg.informatik.ultimate.logic.Rational) {
            de.uni_freiburg.informatik.ultimate.logic.Rational rationalValue = (de.uni_freiburg.informatik.ultimate.logic.Rational)((ConstantTerm)value).getValue();
            Rational out = Rational.of((BigInteger)rationalValue.numerator(), (BigInteger)rationalValue.denominator());
            if (this.formulaCreator.getFormulaTypeOfSort(value.getSort()).isIntegerType()) {
                assert (out.isIntegral());
                return out.getNum();
            }
            return out;
        }
        throw new AssertionError((Object)("unexpected value: " + value));
    }

    @Override
    public void close() {
    }
}

