/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.Collection;
import org.sosy_lab.solver.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaCreator;

class SmtInterpolBooleanFormulaManager
extends AbstractBooleanFormulaManager<Term, Sort, SmtInterpolEnvironment, FunctionSymbol> {
    private final Theory theory;

    SmtInterpolBooleanFormulaManager(SmtInterpolFormulaCreator creator, Theory pTheory) {
        super(creator);
        this.theory = pTheory;
    }

    @Override
    public Term makeVariableImpl(String varName) {
        return (Term)this.formulaCreator.makeVariable((Sort)this.formulaCreator.getBoolType(), varName);
    }

    @Override
    public Term makeBooleanImpl(boolean pValue) {
        ApplicationTerm t = pValue ? this.theory.mTrue : this.theory.mFalse;
        return t;
    }

    @Override
    public Term equivalence(Term t1, Term t2) {
        assert (t1.getTheory().getBooleanSort() == t1.getSort() && t2.getTheory().getBooleanSort() == t2.getSort()) : "Cannot make equivalence of non-boolean terms:\nTerm 1:\n" + t1.toStringDirect() + "\nTerm 2:\n" + t2.toStringDirect();
        return this.theory.equals(new Term[]{t1, t2});
    }

    @Override
    public boolean isTrue(Term t) {
        return t.getTheory().mTrue == t;
    }

    @Override
    public boolean isFalse(Term t) {
        return t.getTheory().mFalse == t;
    }

    @Override
    public Term ifThenElse(Term condition, Term t1, Term t2) {
        return this.theory.ifthenelse(condition, t1, t2);
    }

    @Override
    public Term not(Term pBits) {
        return this.theory.not(pBits);
    }

    @Override
    public Term and(Term pBits1, Term pBits2) {
        return this.theory.and(new Term[]{pBits1, pBits2});
    }

    @Override
    protected Term andImpl(Collection<Term> pParams) {
        return this.theory.and(pParams.toArray(new Term[pParams.size()]));
    }

    @Override
    public Term or(Term pBits1, Term pBits2) {
        return this.theory.or(new Term[]{pBits1, pBits2});
    }

    @Override
    protected Term orImpl(Collection<Term> pParams) {
        return this.theory.or(pParams.toArray(new Term[pParams.size()]));
    }

    @Override
    public Term xor(Term pBits1, Term pBits2) {
        return this.theory.xor(pBits1, pBits2);
    }
}

