/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.parser.BooleanCompactifier;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.PartialEvaluator;
import com.google.common.collect.Iterables;
import org.sosy_lab.common.Appender;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractFormulaManager;
import org.sosy_lab.solver.princess.PrincessArrayFormulaManager;
import org.sosy_lab.solver.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.princess.PrincessFunctionDeclaration;
import org.sosy_lab.solver.princess.PrincessIntegerFormulaManager;
import org.sosy_lab.solver.princess.PrincessQuantifiedFormulaManager;
import org.sosy_lab.solver.princess.PrincessTermType;
import org.sosy_lab.solver.princess.PrincessUFManager;

final class PrincessFormulaManager
extends AbstractFormulaManager<IExpression, PrincessTermType, PrincessEnvironment, PrincessFunctionDeclaration> {
    private final PrincessFormulaCreator creator;

    PrincessFormulaManager(PrincessFormulaCreator pCreator, PrincessUFManager pFunctionManager, PrincessBooleanFormulaManager pBooleanManager, PrincessIntegerFormulaManager pIntegerManager, PrincessArrayFormulaManager pArrayManager, PrincessQuantifiedFormulaManager pQuantifierManager) {
        super(pCreator, pFunctionManager, pBooleanManager, pIntegerManager, null, null, null, pQuantifierManager, pArrayManager);
        this.creator = pCreator;
    }

    BooleanFormula encapsulateBooleanFormula(IExpression t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.encapsulateBooleanFormula((IExpression)Iterables.getOnlyElement(((PrincessEnvironment)this.getEnvironment()).parseStringToTerms(pS, this.creator)));
    }

    @Override
    public Appender dumpFormula(IExpression formula) {
        assert (this.getFormulaCreator().getFormulaType(formula) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return ((PrincessEnvironment)this.getEnvironment()).dumpFormula((IFormula)formula, this.creator);
    }

    @Override
    protected IExpression simplify(IExpression f) {
        if (f instanceof IFormula) {
            f = BooleanCompactifier.apply((IFormula)((IFormula)f));
        }
        return PartialEvaluator.apply((IExpression)f);
    }
}

