/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.MoreFiles;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractSolverContext;
import org.sosy_lab.solver.mathsat5.Mathsat5ArrayFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5BitvectorFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5BooleanFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5FloatingPointFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5IntegerFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5InterpolatingProver;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.mathsat5.Mathsat5OptimizationProver;
import org.sosy_lab.solver.mathsat5.Mathsat5RationalFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5TheoremProver;
import org.sosy_lab.solver.mathsat5.Mathsat5UFManager;

public final class Mathsat5SolverContext
extends AbstractSolverContext {
    private static final boolean USE_SHARED_ENV = true;
    private static final boolean USE_GHOST_FILTER = true;
    private final LogManager logger;
    private final long mathsatConfig;
    private final Mathsat5Settings settings;
    private final long randomSeed;
    private final ShutdownNotifier shutdownNotifier;
    private final Mathsat5NativeApi.TerminationTest terminationTest;
    private final Mathsat5FormulaCreator creator;
    private static boolean loaded = false;

    public Mathsat5SolverContext(LogManager logger, long mathsatConfig, Mathsat5Settings settings, long randomSeed, ShutdownNotifier shutdownNotifier, Mathsat5FormulaManager manager, Mathsat5FormulaCreator creator) {
        super(manager);
        if (!loaded) {
            logger.log(Level.WARNING, new Object[]{"MathSAT5 is available for research and evaluation purposes only. It can not be used in a commercial environment, particularly as part of a commercial product, without written permission. MathSAT5 is provided as is, without any warranty. Please write to mathsat@fbk.eu for additional questions regarding licensing MathSAT5 or obtaining more up-to-date versions."});
        }
        this.logger = logger;
        this.mathsatConfig = mathsatConfig;
        this.settings = settings;
        this.randomSeed = randomSeed;
        this.shutdownNotifier = shutdownNotifier;
        this.creator = creator;
        this.terminationTest = () -> {
            shutdownNotifier.shutdownIfNecessary();
            return false;
        };
    }

    public static Mathsat5SolverContext create(LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogFile, long randomSeed) throws InvalidConfigurationException {
        Mathsat5Settings settings = new Mathsat5Settings(config, solverLogFile);
        if (settings.loadOptimathsat5) {
            NativeLibraries.loadLibrary((String)"optimathsat5j");
        } else {
            NativeLibraries.loadLibrary((String)"mathsat5j");
        }
        long msatConf = Mathsat5NativeApi.msat_create_config();
        Mathsat5NativeApi.msat_set_option_checked(msatConf, "theory.la.split_rat_eq", "false");
        Mathsat5NativeApi.msat_set_option_checked(msatConf, "random_seed", Long.toString(randomSeed));
        for (Map.Entry option : settings.furtherOptionsMap.entrySet()) {
            try {
                Mathsat5NativeApi.msat_set_option_checked(msatConf, (String)option.getKey(), (String)option.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        long msatEnv = Mathsat5NativeApi.msat_create_env(msatConf);
        Mathsat5FormulaCreator creator = new Mathsat5FormulaCreator(msatEnv);
        Mathsat5UFManager functionTheory = new Mathsat5UFManager(creator);
        Mathsat5BooleanFormulaManager booleanTheory = new Mathsat5BooleanFormulaManager(creator);
        Mathsat5IntegerFormulaManager integerTheory = new Mathsat5IntegerFormulaManager(creator);
        Mathsat5RationalFormulaManager rationalTheory = new Mathsat5RationalFormulaManager(creator);
        Mathsat5BitvectorFormulaManager bitvectorTheory = Mathsat5BitvectorFormulaManager.create(creator);
        Mathsat5FloatingPointFormulaManager floatingPointTheory = new Mathsat5FloatingPointFormulaManager(creator, functionTheory);
        Mathsat5ArrayFormulaManager arrayTheory = new Mathsat5ArrayFormulaManager(creator);
        Mathsat5FormulaManager manager = new Mathsat5FormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, floatingPointTheory, arrayTheory);
        return new Mathsat5SolverContext(logger, msatConf, settings, randomSeed, pShutdownNotifier, manager, creator);
    }

    long createEnvironment(long cfg) {
        Mathsat5NativeApi.msat_set_option_checked(cfg, "dpll.ghost_filtering", "true");
        Mathsat5NativeApi.msat_set_option_checked(cfg, "theory.la.split_rat_eq", "false");
        Mathsat5NativeApi.msat_set_option_checked(cfg, "random_seed", Long.toString(this.randomSeed));
        for (Map.Entry option : this.settings.furtherOptionsMap.entrySet()) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, (String)option.getKey(), (String)option.getValue());
        }
        if (this.settings.logfile != null) {
            Path filename = this.settings.logfile.getFreshPath();
            try {
                MoreFiles.createParentDirs((Path)filename);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Cannot create directory for MathSAT logfile");
            }
            Mathsat5NativeApi.msat_set_option_checked(cfg, "debug.api_call_trace", "1");
            Mathsat5NativeApi.msat_set_option_checked(cfg, "debug.api_call_trace_filename", filename.toAbsolutePath().toString());
        }
        long env = Mathsat5NativeApi.msat_create_shared_env(cfg, (Long)this.creator.getEnv());
        return env;
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        if (options.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS)) {
            throw new UnsupportedOperationException("Mathsat5 does not support generating UNSAT core over assumptions");
        }
        return new Mathsat5TheoremProver(this, this.shutdownNotifier, this.creator, options);
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0() {
        return new Mathsat5InterpolatingProver(this, this.creator);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        return new Mathsat5OptimizationProver(this, this.creator);
    }

    @Override
    public String getVersion() {
        return Mathsat5NativeApi.msat_get_version();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.MATHSAT5;
    }

    @Override
    public void close() {
        this.logger.log(Level.FINER, new Object[]{"Freeing Mathsat environment"});
        Mathsat5NativeApi.msat_destroy_env((Long)this.creator.getEnv());
        Mathsat5NativeApi.msat_destroy_config(this.mathsatConfig);
    }

    long addTerminationTest(long env) {
        return Mathsat5NativeApi.msat_set_termination_test(env, this.terminationTest);
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return true;
    }

    @Options(prefix="solver.mathsat5")
    private static class Mathsat5Settings {
        @Option(secure=true, description="Further options that will be passed to Mathsat in addition to the default options. Format is 'key1=value1,key2=value2'")
        private String furtherOptions = "";
        @Option(secure=true, description="Load less stable optimizing version of mathsat5 solver.")
        boolean loadOptimathsat5 = false;
        @Nullable
        private final PathCounterTemplate logfile;
        private final ImmutableMap<String, String> furtherOptionsMap;

        private Mathsat5Settings(Configuration config, @Nullable PathCounterTemplate pLogfile) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.logfile = pLogfile;
            Splitter.MapSplitter optionSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator(Splitter.on((char)'=').limit(2).trimResults());
            try {
                this.furtherOptionsMap = ImmutableMap.copyOf((Map)optionSplitter.split((CharSequence)this.furtherOptions));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Invalid Mathsat option in \"" + this.furtherOptions + "\": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

