/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;

public class Mathsat5NativeApiTest {
    private long env;

    @Before
    public void createEnvironment() {
        long cfg = Mathsat5NativeApi.msat_create_config();
        this.env = Mathsat5NativeApi.msat_create_env(cfg);
        Mathsat5NativeApi.msat_destroy_config(cfg);
    }

    @After
    public void freeEnvironment() {
        Mathsat5NativeApi.msat_destroy_env(this.env);
    }

    @Test
    public void bvSize() {
        long number = Mathsat5NativeApi.msat_make_bv_number(this.env, "42", 32, 10);
        long type = Mathsat5NativeApi.msat_term_get_type(number);
        Assert.assertTrue((boolean)Mathsat5NativeApi.msat_is_bv_type(this.env, type));
        Assert.assertEquals((long)32L, (long)Mathsat5NativeApi.msat_get_bv_type_size(this.env, type));
        long funcDecl = Mathsat5NativeApi.msat_declare_function(this.env, "testVar", type);
        long var = Mathsat5NativeApi.msat_make_constant(this.env, funcDecl);
        type = Mathsat5NativeApi.msat_term_get_type(var);
        Assert.assertTrue((boolean)Mathsat5NativeApi.msat_is_bv_type(this.env, type));
        Assert.assertEquals((long)32L, (long)Mathsat5NativeApi.msat_get_bv_type_size(this.env, type));
    }

    @Test
    public void fpExpWidth() {
        long type = Mathsat5NativeApi.msat_get_fp_type(this.env, 8, 23);
        Assert.assertEquals((long)8L, (long)Mathsat5NativeApi.msat_get_fp_type_exp_width(this.env, type));
    }

    @Test
    public void fpMantWidth() {
        long type = Mathsat5NativeApi.msat_get_fp_type(this.env, 8, 23);
        Assert.assertEquals((long)23L, (long)Mathsat5NativeApi.msat_get_fp_type_mant_width(this.env, type));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fpExpWidthIllegal() {
        long type = Mathsat5NativeApi.msat_get_integer_type(this.env);
        Mathsat5NativeApi.msat_get_fp_type_exp_width(this.env, type);
    }

    @Test
    public void modularCongruence() throws InterruptedException, IllegalStateException, SolverException {
        long type = Mathsat5NativeApi.msat_get_integer_type(this.env);
        long v1 = Mathsat5NativeApi.msat_declare_function(this.env, "v1", type);
        long t1 = Mathsat5NativeApi.msat_make_constant(this.env, v1);
        long v2 = Mathsat5NativeApi.msat_declare_function(this.env, "v2", type);
        long t2 = Mathsat5NativeApi.msat_make_constant(this.env, v2);
        long t = Mathsat5NativeApi.msat_make_int_modular_congruence(this.env, 42L, t1, t2);
        Assert.assertEquals((Object)"(`int_mod_congr_42` (`+_int` v1 (`*_int` -1 v2)) 0)", (Object)Mathsat5NativeApi.msat_term_repr(t));
        Mathsat5NativeApi.msat_assert_formula(this.env, t);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "3")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Assert.assertTrue((boolean)Mathsat5NativeApi.msat_check_sat(this.env));
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Assert.assertTrue((boolean)Mathsat5NativeApi.msat_check_sat(this.env));
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "87")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Assert.assertTrue((boolean)Mathsat5NativeApi.msat_check_sat(this.env));
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "4")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Assert.assertFalse((boolean)Mathsat5NativeApi.msat_check_sat(this.env));
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
    }

    static {
        NativeLibraries.loadLibrary((String)"mathsat5j");
    }
}

