/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import java.math.BigDecimal;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.mathsat5.Mathsat5UFManager;

class Mathsat5FloatingPointFormulaManager
extends AbstractFloatingPointFormulaManager<Long, Long, Long, Long> {
    private final Mathsat5UFManager ffmgr;
    private final long mathsatEnv;
    private final long roundingMode;

    Mathsat5FloatingPointFormulaManager(Mathsat5FormulaCreator pCreator, Mathsat5UFManager pFfmgr) {
        super(pCreator);
        this.ffmgr = pFfmgr;
        this.mathsatEnv = (Long)pCreator.getEnv();
        this.roundingMode = Mathsat5NativeApi.msat_make_fp_roundingmode_nearest_even(this.mathsatEnv);
    }

    @Override
    public Long makeNumberImpl(double pN, FormulaType.FloatingPointType pType) {
        if (Double.isNaN(pN)) {
            return this.makeNaNImpl(pType);
        }
        if (Double.isInfinite(pN)) {
            if (pN > 0.0) {
                return this.makePlusInfinityImpl(pType);
            }
            return this.makeMinusInfinityImpl(pType);
        }
        return this.makeNumberImpl(Double.toString(pN), pType);
    }

    @Override
    public Long makeNumberImpl(BigDecimal pN, FormulaType.FloatingPointType pType) {
        return this.makeNumberImpl(pN.toPlainString(), pType);
    }

    @Override
    protected Long makeNumberImpl(String pN, FormulaType.FloatingPointType pType) {
        return Mathsat5NativeApi.msat_make_fp_rat_number(this.mathsatEnv, pN, pType.getExponentSize(), pType.getMantissaSize(), this.roundingMode);
    }

    @Override
    public Long makeVariableImpl(String var, FormulaType.FloatingPointType type) {
        return (Long)this.getFormulaCreator().makeVariable((Long)this.getFormulaCreator().getFloatingPointType(type), var);
    }

    @Override
    protected Long makePlusInfinityImpl(FormulaType.FloatingPointType type) {
        return Mathsat5NativeApi.msat_make_fp_plus_inf(this.mathsatEnv, type.getExponentSize(), type.getMantissaSize());
    }

    @Override
    protected Long makeMinusInfinityImpl(FormulaType.FloatingPointType type) {
        return Mathsat5NativeApi.msat_make_fp_minus_inf(this.mathsatEnv, type.getExponentSize(), type.getMantissaSize());
    }

    @Override
    protected Long makeNaNImpl(FormulaType.FloatingPointType type) {
        return Mathsat5NativeApi.msat_make_fp_nan(this.mathsatEnv, type.getExponentSize(), type.getMantissaSize());
    }

    @Override
    protected Long castToImpl(Long pNumber, FormulaType<?> pTargetType) {
        if (pTargetType.isFloatingPointType()) {
            FormulaType.FloatingPointType targetType = (FormulaType.FloatingPointType)pTargetType;
            return Mathsat5NativeApi.msat_make_fp_cast(this.mathsatEnv, targetType.getExponentSize(), targetType.getMantissaSize(), this.roundingMode, pNumber);
        }
        if (pTargetType.isBitvectorType()) {
            FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)pTargetType;
            return Mathsat5NativeApi.msat_make_fp_to_bv(this.mathsatEnv, targetType.getSize(), this.roundingMode, pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    @Override
    protected Long castFromImpl(Long pNumber, boolean signed, FormulaType.FloatingPointType pTargetType) {
        FormulaType<?> formulaType = this.getFormulaCreator().getFormulaType(pNumber);
        if (formulaType.isFloatingPointType()) {
            return this.castToImpl(pNumber, (FormulaType<?>)pTargetType);
        }
        if (formulaType.isBitvectorType()) {
            if (signed) {
                return Mathsat5NativeApi.msat_make_fp_from_sbv(this.mathsatEnv, pTargetType.getExponentSize(), pTargetType.getMantissaSize(), this.roundingMode, pNumber);
            }
            return Mathsat5NativeApi.msat_make_fp_from_ubv(this.mathsatEnv, pTargetType.getExponentSize(), pTargetType.getMantissaSize(), this.roundingMode, pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    private Long genericCast(Long pNumber, FormulaType<?> pTargetType) {
        long msatArgType = Mathsat5NativeApi.msat_term_get_type(pNumber);
        FormulaType<?> argType = this.getFormulaCreator().getFormulaType(pNumber);
        long castFuncDecl = this.ffmgr.createFunctionImpl("__cast_" + argType + "_to_" + pTargetType, (Long)this.toSolverType(pTargetType), new long[]{msatArgType});
        return this.ffmgr.createUIFCallImpl(castFuncDecl, new long[]{pNumber});
    }

    @Override
    public Long negate(Long pNumber) {
        return Mathsat5NativeApi.msat_make_fp_neg(this.mathsatEnv, pNumber);
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_plus(this.mathsatEnv, this.roundingMode, pNumber1, pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_minus(this.mathsatEnv, this.roundingMode, pNumber1, pNumber2);
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_times(this.mathsatEnv, this.roundingMode, pNumber1, pNumber2);
    }

    @Override
    protected Long divide(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_div(this.mathsatEnv, this.roundingMode, pNumber1, pNumber2);
    }

    @Override
    protected Long assignment(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long equalWithFPSemantics(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2) {
        return this.lessThan(pNumber2, pNumber1);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return this.lessOrEquals(pNumber2, pNumber1);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_lt(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_leq(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long isNaN(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_isnan(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isInfinity(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_isinf(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isZero(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_iszero(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isSubnormal(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_issubnormal(this.mathsatEnv, pParam);
    }
}

