/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.logging;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.SolverContextStatistics;
import org.sosy_lab.solver.logging.LoggingInterpolatingProverEnvironment;
import org.sosy_lab.solver.logging.LoggingOptimizationProverEnvironment;
import org.sosy_lab.solver.logging.LoggingProverEnvironment;

public final class LoggingSolverContext
implements SolverContext {
    private final LogManager logger;
    private final SolverContext delegate;

    public LoggingSolverContext(LogManager pLogger, SolverContext pDelegate) {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.delegate = (SolverContext)Preconditions.checkNotNull((Object)pDelegate);
    }

    @Override
    public FormulaManager getFormulaManager() {
        return this.delegate.getFormulaManager();
    }

    @Override
    public ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... pOptions) {
        return new LoggingProverEnvironment(this.logger, this.delegate.newProverEnvironment(pOptions));
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation() {
        return new LoggingInterpolatingProverEnvironment(this.logger, this.delegate.newProverEnvironmentWithInterpolation());
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        return new LoggingOptimizationProverEnvironment(this.logger, this.delegate.newOptimizationProverEnvironment());
    }

    @Override
    public OptimizationProverEnvironment newCachedOptimizationProverEnvironment() {
        return this.delegate.newCachedOptimizationProverEnvironment();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return this.delegate.getSolverName();
    }

    @Override
    public SolverContextStatistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

