/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.logging;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.logging.LoggingBasicProverEnvironment;

class LoggingOptimizationProverEnvironment
extends LoggingBasicProverEnvironment<Void>
implements OptimizationProverEnvironment {
    private final OptimizationProverEnvironment wrapped;

    LoggingOptimizationProverEnvironment(LogManager logger, OptimizationProverEnvironment oe) {
        super(oe, logger);
        this.wrapped = (OptimizationProverEnvironment)Preconditions.checkNotNull((Object)oe);
    }

    @Override
    public int maximize(Formula objective) {
        this.logger.log(Level.FINE, new Object[]{"Maximizing:", objective});
        return this.wrapped.maximize(objective);
    }

    @Override
    public int minimize(Formula objective) {
        this.logger.log(Level.FINE, new Object[]{"Minimizing:", objective});
        return this.wrapped.minimize(objective);
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        OptimizationProverEnvironment.OptStatus result = this.wrapped.check();
        this.logger.log(Level.FINE, new Object[]{"optimization returned", result});
        return result;
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        return this.wrapped.upper(handle, epsilon);
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        return this.wrapped.lower(handle, epsilon);
    }
}

