/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.example;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.visitors.FormulaTransformationVisitor;

public class HoudiniApp {
    private final FormulaManager fmgr;
    private final BooleanFormulaManager bfmgr;
    private final SolverContext context;

    public static void main(String ... args) throws Exception {
        LogManager mainLogger = BasicLogManager.create((Configuration)Configuration.defaultConfiguration());
        for (SolverContextFactory.Solvers solver : SolverContextFactory.Solvers.values()) {
            mainLogger.log(Level.INFO, new Object[]{"using solver", solver});
            HoudiniApp houdini = new HoudiniApp("--solver.solver=" + (Object)((Object)solver));
            IntegerFormulaManager ifmgr = houdini.fmgr.getIntegerFormulaManager();
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("X");
            NumeralFormula.IntegerFormula xPrimed = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("X'");
            NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)ifmgr.makeNumber(1L);
            ImmutableList lemmas = ImmutableList.of((Object)ifmgr.greaterThan(x, one), (Object)ifmgr.lessThan(x, one));
            BooleanFormula transition = ifmgr.equal(xPrimed, (NumeralFormula.IntegerFormula)ifmgr.add(x, one));
            List<BooleanFormula> result = houdini.houdini((List<BooleanFormula>)lemmas, transition);
            mainLogger.log(Level.INFO, new Object[]{"Houdini returned", result});
        }
    }

    public HoudiniApp(String ... args) throws Exception {
        Configuration config = Configuration.fromCmdLineArguments((String[])args);
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownManager.create().getNotifier();
        this.context = SolverContextFactory.createSolverContext(config, logger, notifier);
        this.fmgr = this.context.getFormulaManager();
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
    }

    private BooleanFormula getSelectorVar(int idx) {
        return this.bfmgr.makeVariable("SEL_" + idx);
    }

    private BooleanFormula prime(BooleanFormula input) {
        return this.fmgr.transformRecursively(input, new FormulaTransformationVisitor(this.fmgr){

            @Override
            public Formula visitFreeVariable(Formula f, String name) {
                return HoudiniApp.this.fmgr.makeVariable(HoudiniApp.this.fmgr.getFormulaType(f), name + "'");
            }
        });
    }

    public List<BooleanFormula> houdini(List<BooleanFormula> lemmas, BooleanFormula transition) throws Exception {
        ArrayList<BooleanFormula> annotated = new ArrayList<BooleanFormula>();
        ArrayList<BooleanFormula> annotatedPrimes = new ArrayList<BooleanFormula>();
        HashMap<Integer, BooleanFormula> indexed = new HashMap<Integer, BooleanFormula>();
        for (int i = 0; i < lemmas.size(); ++i) {
            BooleanFormula lemma = lemmas.get(i);
            BooleanFormula primed = this.prime(lemma);
            annotated.add(this.bfmgr.or(this.getSelectorVar(i), lemma));
            annotatedPrimes.add(this.bfmgr.or(this.getSelectorVar(i), primed));
            indexed.put(i, lemma);
        }
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.addConstraint(transition);
            prover.addConstraint(this.bfmgr.and(annotated));
            prover.addConstraint(this.bfmgr.not(this.bfmgr.and(annotatedPrimes)));
            while (!prover.isUnsat()) {
                Model m = prover.getModel();
                Throwable throwable = null;
                try {
                    for (int i = 0; i < annotatedPrimes.size(); ++i) {
                        BooleanFormula annotatedPrime = (BooleanFormula)annotatedPrimes.get(i);
                        if (m.evaluate(annotatedPrime).booleanValue()) continue;
                        prover.addConstraint(this.getSelectorVar(i));
                        indexed.remove(i);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (m == null) continue;
                    if (throwable != null) {
                        try {
                            m.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    m.close();
                }
            }
        }
        return new ArrayList<BooleanFormula>(indexed.values());
    }
}

