/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.withAssumptionsWrapper;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.basicimpl.withAssumptionsWrapper.BasicProverWithAssumptionsWrapper;
import org.sosy_lab.solver.visitors.BooleanFormulaTransformationVisitor;

public class InterpolatingProverWithAssumptionsWrapper<T>
extends BasicProverWithAssumptionsWrapper<T, InterpolatingProverEnvironment<T>>
implements InterpolatingProverEnvironment<T> {
    private final List<T> solverAssumptionsFromPush = new ArrayList<T>();
    private final FormulaManager fmgr;
    private final BooleanFormulaManager bmgr;

    public InterpolatingProverWithAssumptionsWrapper(InterpolatingProverEnvironment<T> pDelegate, FormulaManager pFmgr) {
        super(pDelegate);
        this.fmgr = (FormulaManager)Preconditions.checkNotNull((Object)pFmgr);
        this.bmgr = this.fmgr.getBooleanFormulaManager();
    }

    @Override
    public BooleanFormula getInterpolant(List<T> pFormulasOfA) throws SolverException, InterruptedException {
        ArrayList completeListOfA = Lists.newArrayList(pFormulasOfA);
        completeListOfA.addAll(this.solverAssumptionsFromPush);
        BooleanFormula interpolant = ((InterpolatingProverEnvironment)this.delegate).getInterpolant(completeListOfA);
        if (!this.solverAssumptionsAsFormula.isEmpty()) {
            interpolant = this.bmgr.transformRecursively(interpolant, new RemoveAssumptionsFromFormulaVisitor());
        }
        return interpolant;
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<T>> pPartitionedFormulas) throws SolverException, InterruptedException {
        if (this.solverAssumptionsAsFormula.isEmpty()) {
            return ((InterpolatingProverEnvironment)this.delegate).getSeqInterpolants(pPartitionedFormulas);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<T>> pPartitionedFormulas, int[] pStartOfSubTree) throws SolverException, InterruptedException {
        if (this.solverAssumptionsAsFormula.isEmpty()) {
            return ((InterpolatingProverEnvironment)this.delegate).getTreeInterpolants(pPartitionedFormulas, pStartOfSubTree);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.clearAssumptions();
        this.solverAssumptionsAsFormula.addAll(assumptions);
        for (BooleanFormula formula : assumptions) {
            this.solverAssumptionsFromPush.add(((InterpolatingProverEnvironment)this.delegate).push(formula));
        }
        return ((InterpolatingProverEnvironment)this.delegate).isUnsat();
    }

    @Override
    protected void clearAssumptions() {
        super.clearAssumptions();
        this.solverAssumptionsFromPush.clear();
    }

    class RemoveAssumptionsFromFormulaVisitor
    extends BooleanFormulaTransformationVisitor {
        private RemoveAssumptionsFromFormulaVisitor() {
            super(InterpolatingProverWithAssumptionsWrapper.this.fmgr);
        }

        @Override
        public BooleanFormula visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> decl) {
            if (decl.getKind() == FunctionDeclarationKind.VAR) {
                String varName = decl.getName();
                if (this.solverAssumptionsContainsVar(varName)) {
                    return InterpolatingProverWithAssumptionsWrapper.this.bmgr.makeBoolean(true);
                }
                return InterpolatingProverWithAssumptionsWrapper.this.bmgr.makeVariable(varName);
            }
            return atom;
        }

        private boolean solverAssumptionsContainsVar(String variableName) {
            for (BooleanFormula solverVar : InterpolatingProverWithAssumptionsWrapper.this.solverAssumptionsAsFormula) {
                if (!InterpolatingProverWithAssumptionsWrapper.this.fmgr.extractVariables(solverVar).keySet().contains(variableName)) continue;
                return true;
            }
            return false;
        }
    }
}

