/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.withAssumptionsWrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;

public class BasicProverWithAssumptionsWrapper<T, P extends BasicProverEnvironment<T>>
implements BasicProverEnvironment<T> {
    protected final P delegate;
    protected final List<BooleanFormula> solverAssumptionsAsFormula = new ArrayList<BooleanFormula>();

    BasicProverWithAssumptionsWrapper(P pDelegate) {
        this.delegate = pDelegate;
    }

    protected void clearAssumptions() {
        for (int i = 0; i < this.solverAssumptionsAsFormula.size(); ++i) {
            this.delegate.pop();
        }
        this.solverAssumptionsAsFormula.clear();
    }

    @Override
    public void pop() {
        this.clearAssumptions();
        this.delegate.pop();
    }

    @Override
    public T addConstraint(BooleanFormula constraint) {
        return this.delegate.addConstraint(constraint);
    }

    @Override
    public void push() {
        this.clearAssumptions();
        this.delegate.push();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        this.clearAssumptions();
        return this.delegate.isUnsat();
    }

    @Override
    public Model getModel() throws SolverException {
        return this.delegate.getModel();
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        return this.delegate.getModelAssignments();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

