/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.tactics;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.FloatingPointFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.tactics.AutoValue_UfElimination_UninterpretedFunctionApplication;
import org.sosy_lab.solver.visitors.DefaultFormulaVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

public class UfElimination {
    private static final UniqueIdGenerator UNIQUE_ID_GENERATOR = new UniqueIdGenerator();
    private static final String prefix = "__UF_fresh_";
    private final BooleanFormulaManager bfmgr;
    private final FormulaManager fmgr;

    public UfElimination(FormulaManager pFmgr) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.fmgr = pFmgr;
    }

    public Result eliminateUfs(BooleanFormula f) {
        Preconditions.checkArgument((!this.isQuantifed(f) ? 1 : 0) != 0);
        Multimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> ufs = this.findUFs(f);
        int depth = this.getNestingDepthOfUfs(f);
        ImmutableMap.Builder substitutionsBuilder = ImmutableMap.builder();
        List<BooleanFormula> extraConstraints = new ArrayList<BooleanFormula>();
        for (FunctionDeclaration function : ufs.keySet()) {
            ArrayList applications = new ArrayList(ufs.get((Object)function));
            for (int idx1 = 0; idx1 < applications.size(); ++idx1) {
                UninterpretedFunctionApplication application = (UninterpretedFunctionApplication)applications.get(idx1);
                Formula uf = application.getFormula();
                List<Formula> args = application.getArguments();
                Formula substitution = application.getSubstitution();
                substitutionsBuilder.put((Object)uf, (Object)substitution);
                for (int idx2 = idx1 + 1; idx2 < applications.size(); ++idx2) {
                    UninterpretedFunctionApplication application2 = (UninterpretedFunctionApplication)applications.get(idx2);
                    List<Formula> otherArgs = application2.getArguments();
                    Verify.verify((args.size() == otherArgs.size() ? 1 : 0) != 0);
                    ArrayList<BooleanFormula> argumentEquility = new ArrayList<BooleanFormula>(args.size());
                    for (int i = 0; i < args.size(); ++i) {
                        Formula arg1 = args.get(i);
                        Formula arg2 = otherArgs.get(i);
                        argumentEquility.add(this.makeEqual(arg1, arg2));
                    }
                    BooleanFormula functionEquility = this.makeEqual(substitution, application2.getSubstitution());
                    extraConstraints.add(this.bfmgr.implication(this.bfmgr.and(argumentEquility), functionEquility));
                }
            }
        }
        ImmutableMap substitutions = substitutionsBuilder.build();
        BooleanFormula formulaNoUFs = this.fmgr.substitute(f, (Map<? extends Formula, ? extends Formula>)substitutions);
        for (int i = 0; i < depth; ++i) {
            extraConstraints = extraConstraints.stream().map(c -> this.fmgr.substitute(c, (Map<? extends Formula, ? extends Formula>)substitutions)).collect(Collectors.toList());
        }
        BooleanFormula newFormula = this.bfmgr.and(this.bfmgr.and(extraConstraints), formulaNoUFs);
        return new Result(newFormula, (ImmutableMap<Formula, Formula>)substitutions);
    }

    @CheckReturnValue
    private BooleanFormula makeEqual(Formula pLhs, Formula pRhs) {
        BooleanFormula t;
        if (pLhs instanceof BooleanFormula && pRhs instanceof BooleanFormula) {
            t = this.bfmgr.equivalence((BooleanFormula)pLhs, (BooleanFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            t = this.fmgr.getIntegerFormulaManager().equal((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            t = this.fmgr.getRationalFormulaManager().equal((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula) {
            t = this.fmgr.getBitvectorFormulaManager().equal((BitvectorFormula)pLhs, (BitvectorFormula)pRhs);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            FloatingPointFormulaManager fpfmgr = this.fmgr.getFloatingPointFormulaManager();
            t = fpfmgr.equalWithFPSemantics((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else if (pLhs instanceof ArrayFormula && pRhs instanceof ArrayFormula) {
            ArrayFormula lhs = (ArrayFormula)pLhs;
            ArrayFormula rhs = (ArrayFormula)pRhs;
            t = this.fmgr.getArrayFormulaManager().equivalence(lhs, rhs);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }

    private boolean isQuantifed(Formula f) {
        final AtomicBoolean result = new AtomicBoolean();
        this.fmgr.visitRecursively(f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula pF) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQ, List<Formula> pBoundVariables, BooleanFormula pBody) {
                result.set(true);
                return TraversalProcess.ABORT;
            }
        });
        return result.get();
    }

    private int getNestingDepthOfUfs(Formula f) {
        return this.fmgr.visit(f, new DefaultFormulaVisitor<Integer>(){

            @Override
            protected Integer visitDefault(Formula pF) {
                return 0;
            }

            @Override
            public Integer visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
                int depthOfArgs = pArgs.stream().mapToInt(f -> UfElimination.this.fmgr.visit((Formula)f, this)).max().orElse(0);
                if (pFunctionDeclaration.getKind() == FunctionDeclarationKind.UF) {
                    return depthOfArgs + 1;
                }
                return depthOfArgs;
            }

            @Override
            public Integer visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQ, List<Formula> pBoundVariables, BooleanFormula pBody) {
                return UfElimination.this.fmgr.visit(pBody, this);
            }
        });
    }

    private Multimap<FunctionDeclaration<?>, UninterpretedFunctionApplication> findUFs(Formula f) {
        HashMultimap ufs = HashMultimap.create();
        this.fmgr.visitRecursively(f, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>((Multimap)ufs){
            final /* synthetic */ Multimap val$ufs;
            {
                this.val$ufs = multimap;
            }

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> decl) {
                if (decl.getKind() == FunctionDeclarationKind.UF) {
                    Formula substitution = UfElimination.this.freshUfReplaceVariable(decl.getType());
                    this.val$ufs.put(decl, (Object)UninterpretedFunctionApplication.create(f, args, substitution));
                }
                return TraversalProcess.CONTINUE;
            }
        });
        return ufs;
    }

    private Formula freshUfReplaceVariable(FormulaType<?> pType) {
        return this.fmgr.makeVariable(pType, prefix + UNIQUE_ID_GENERATOR.getFreshId());
    }

    static abstract class UninterpretedFunctionApplication {
        UninterpretedFunctionApplication() {
        }

        static UninterpretedFunctionApplication create(Formula pF, List<Formula> pArguments, Formula pSubstitution) {
            return new AutoValue_UfElimination_UninterpretedFunctionApplication(pF, pArguments, pSubstitution);
        }

        abstract Formula getFormula();

        abstract List<Formula> getArguments();

        abstract Formula getSubstitution();
    }

    public static class Result {
        private final BooleanFormula formula;
        private final Map<Formula, Formula> substitutions;

        Result(BooleanFormula pFormula, ImmutableMap<Formula, Formula> pSubstitutions) {
            this.formula = (BooleanFormula)Preconditions.checkNotNull((Object)pFormula);
            this.substitutions = (Map)Preconditions.checkNotNull(pSubstitutions);
        }

        public BooleanFormula getFormula() {
            return this.formula;
        }

        public Map<Formula, Formula> getSubstitution() {
            return this.substitutions;
        }
    }
}

