/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.reusableStack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.Model;

abstract class ReusableStackAbstractProver<T, D extends BasicProverEnvironment<T>>
implements BasicProverEnvironment<T> {
    D delegate;
    private int size;

    ReusableStackAbstractProver(D pDelegate) {
        this.delegate = (BasicProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.delegate.push();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        Preconditions.checkState((this.size >= 0 ? 1 : 0) != 0);
        return this.delegate.isUnsat();
    }

    @Override
    public final void push() {
        ++this.size;
        this.delegate.push();
    }

    @Override
    public void pop() {
        Preconditions.checkState((this.size > 0 ? 1 : 0) != 0);
        --this.size;
        this.delegate.pop();
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((this.size >= 0 ? 1 : 0) != 0);
        return this.delegate.getModel();
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((this.size >= 0 ? 1 : 0) != 0);
        return this.delegate.getModelAssignments();
    }

    @Override
    public void close() {
        while (this.size > 0) {
            this.pop();
        }
        Preconditions.checkState((this.size == 0 ? 1 : 0) != 0);
        this.delegate.pop();
        this.delegate.close();
    }
}

