/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.cache;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.basicimpl.cache.CachedModel;
import org.sosy_lab.solver.basicimpl.cache.OptimizationCacheStatistics;
import org.sosy_lab.solver.basicimpl.cache.OptimizationObjective;
import org.sosy_lab.solver.basicimpl.cache.OptimizationQuery;
import org.sosy_lab.solver.basicimpl.cache.OptimizationResult;

public class CachingOptimizationProverEnvironment
implements OptimizationProverEnvironment {
    private final Map<OptimizationQuery, OptimizationResult> optimizationCache;
    private final Deque<OptimizationQuery> stack;
    private final OptimizationProverEnvironment delegate;
    private final OptimizationCacheStatistics statistics;
    private transient OptimizationQuery currentQuery = OptimizationQuery.empty();
    private transient boolean checkPerformed;

    public CachingOptimizationProverEnvironment(OptimizationProverEnvironment pDelegate, Map<OptimizationQuery, OptimizationResult> pCache, OptimizationCacheStatistics pStatistics) {
        this.delegate = pDelegate;
        this.optimizationCache = pCache;
        this.statistics = pStatistics;
        this.stack = new ArrayDeque<OptimizationQuery>();
        this.checkPerformed = false;
    }

    @Override
    public int maximize(Formula objective) {
        this.checkPerformed = false;
        int handle = this.delegate.maximize(objective);
        this.currentQuery = this.currentQuery.addObjective(OptimizationObjective.maxObjective(objective), handle);
        return handle;
    }

    @Override
    public int minimize(Formula objective) {
        this.checkPerformed = false;
        int handle = this.delegate.maximize(objective);
        this.currentQuery = this.currentQuery.addObjective(OptimizationObjective.minObjective(objective), handle);
        return handle;
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        this.checkPerformed = false;
        this.currentQuery = this.currentQuery.addConstraint(constraint);
        return (Void)this.delegate.addConstraint(constraint);
    }

    @Override
    @Nullable
    public Void push(BooleanFormula f) {
        this.checkPerformed = false;
        Void out = this.addConstraint(f);
        this.push();
        return out;
    }

    @Override
    public void push() {
        this.checkPerformed = false;
        this.stack.push(this.currentQuery);
        this.delegate.push();
    }

    @Override
    public void pop() {
        this.checkPerformed = false;
        this.currentQuery = this.stack.pop();
        this.delegate.pop();
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        OptimizationResult cachedResult = this.optimizationCache.get(this.currentQuery);
        this.statistics.incChecks();
        if (cachedResult != null) {
            this.statistics.incCacheHits();
            return cachedResult.result();
        }
        OptimizationProverEnvironment.OptStatus out = this.delegate.check();
        this.checkPerformed = true;
        this.optimizationCache.put(this.currentQuery, OptimizationResult.of(out));
        return out;
    }

    private OptimizationProverEnvironment.OptStatus forceCheck() {
        try {
            OptimizationProverEnvironment.OptStatus optStatus = this.delegate.check();
            return optStatus;
        }
        catch (InterruptedException | SolverException pE) {
            throw new UnsupportedOperationException("Solver exception", pE);
        }
        finally {
            this.checkPerformed = true;
        }
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        OptimizationResult cachedResult = this.optimizationCache.get(this.currentQuery);
        assert (cachedResult != null);
        if (epsilon.equals((Object)Rational.ZERO) && cachedResult.objectiveValues().containsKey((Object)handle)) {
            return (Optional)cachedResult.objectiveValues().get((Object)handle);
        }
        if (!this.checkPerformed) {
            this.forceCheck();
        }
        Optional<Rational> out = this.delegate.upper(handle, epsilon);
        this.optimizationCache.put(this.currentQuery, cachedResult.withObjectiveValue(handle, out));
        return out;
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        OptimizationResult cachedResult = this.optimizationCache.get(this.currentQuery);
        assert (cachedResult != null);
        if (epsilon.equals((Object)Rational.ZERO) && cachedResult.objectiveValues().containsKey((Object)handle)) {
            return (Optional)cachedResult.objectiveValues().get((Object)handle);
        }
        if (!this.checkPerformed) {
            this.forceCheck();
        }
        Optional<Rational> out = this.delegate.lower(handle, epsilon);
        this.optimizationCache.put(this.currentQuery, cachedResult.withObjectiveValue(handle, out));
        return out;
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        return this.check() == OptimizationProverEnvironment.OptStatus.UNSAT;
    }

    @Override
    public Model getModel() throws SolverException {
        OptimizationResult cachedResult = this.optimizationCache.get(this.currentQuery);
        assert (cachedResult != null);
        if (cachedResult.model().isPresent()) {
            return cachedResult.model().get();
        }
        if (!this.checkPerformed) {
            this.forceCheck();
        }
        Model model = this.delegate.getModel();
        CachedModel cachedModel = new CachedModel(model);
        this.optimizationCache.put(this.currentQuery, cachedResult.withModel(cachedModel));
        return cachedModel;
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        return ImmutableList.copyOf(this.getModel().iterator());
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

