/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.visitors.FormulaVisitor;

final class FormulaTransformationVisitorImpl
implements FormulaVisitor<Void> {
    private final Deque<Formula> toProcess;
    private final Map<Formula, Formula> pCache;
    private final FormulaVisitor<? extends Formula> delegate;

    FormulaTransformationVisitorImpl(FormulaVisitor<? extends Formula> delegate, Deque<Formula> toProcess, Map<Formula, Formula> pCache) {
        this.toProcess = toProcess;
        this.pCache = pCache;
        this.delegate = (FormulaVisitor)Preconditions.checkNotNull(delegate);
    }

    @Override
    public Void visitFreeVariable(Formula f, String name) {
        this.pCache.put(f, this.delegate.visitFreeVariable(f, name));
        return null;
    }

    @Override
    public Void visitBoundVariable(Formula f, int deBruijnIdx) {
        this.pCache.put(f, f);
        return null;
    }

    @Override
    public Void visitConstant(Formula f, Object value) {
        this.pCache.put(f, this.delegate.visitConstant(f, value));
        return null;
    }

    @Override
    public Void visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
        boolean allArgumentsTransformed = true;
        ArrayList<Formula> newArgs = new ArrayList<Formula>(args.size());
        for (Formula c : args) {
            Formula newC = this.pCache.get(c);
            if (newC != null) {
                newArgs.add(newC);
                continue;
            }
            this.toProcess.push(c);
            allArgumentsTransformed = false;
        }
        if (allArgumentsTransformed) {
            this.toProcess.pop();
            Formula out = this.delegate.visitFunction(f, newArgs, functionDeclaration);
            Formula prev = this.pCache.put(f, out);
            assert (prev == null);
        }
        return null;
    }

    @Override
    public Void visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
        BooleanFormula transformedBody = (BooleanFormula)this.pCache.get(body);
        if (transformedBody != null) {
            BooleanFormula newTt = (BooleanFormula)this.delegate.visitQuantifier(f, quantifier, boundVariables, transformedBody);
            this.pCache.put(f, newTt);
        } else {
            this.toProcess.push(body);
        }
        return null;
    }
}

