/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.SolverContextStatistics;
import org.sosy_lab.solver.basicimpl.cache.CachingOptimizationProverEnvironment;
import org.sosy_lab.solver.basicimpl.cache.OptimizationQuery;
import org.sosy_lab.solver.basicimpl.cache.OptimizationResult;
import org.sosy_lab.solver.basicimpl.withAssumptionsWrapper.InterpolatingProverWithAssumptionsWrapper;
import org.sosy_lab.solver.basicimpl.withAssumptionsWrapper.ProverWithAssumptionsWrapper;

public abstract class AbstractSolverContext
implements SolverContext {
    private final FormulaManager fmgr;
    private final Map<OptimizationQuery, OptimizationResult> optimizationCache;
    private final SolverContextStatistics statistics;

    protected AbstractSolverContext(FormulaManager fmgr) {
        this.fmgr = fmgr;
        this.optimizationCache = new HashMap<OptimizationQuery, OptimizationResult>();
        this.statistics = new SolverContextStatistics();
    }

    @Override
    public final FormulaManager getFormulaManager() {
        return this.fmgr;
    }

    @Override
    public final ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... options) {
        EnumSet<SolverContext.ProverOptions> opts = EnumSet.noneOf(SolverContext.ProverOptions.class);
        Collections.addAll(opts, options);
        ProverEnvironment out = this.newProverEnvironment0(opts);
        if (!this.supportsAssumptionSolving()) {
            out = new ProverWithAssumptionsWrapper(out);
        }
        return out;
    }

    protected abstract ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> var1);

    @Override
    public final InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation() {
        InterpolatingProverEnvironment<?> out = this.newProverEnvironmentWithInterpolation0();
        if (!this.supportsAssumptionSolving()) {
            out = new InterpolatingProverWithAssumptionsWrapper(out, this.fmgr);
        }
        return out;
    }

    protected abstract InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0();

    protected abstract boolean supportsAssumptionSolving();

    @Override
    public final OptimizationProverEnvironment newCachedOptimizationProverEnvironment() {
        return new CachingOptimizationProverEnvironment(this.newOptimizationProverEnvironment(), this.optimizationCache, this.statistics.getOptimizationCacheStatistics());
    }

    @Override
    public SolverContextStatistics getStatistics() {
        return this.statistics;
    }
}

