/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.basicimpl.FormulaCreator;

public abstract class AbstractModel<TFormulaInfo, TType, TEnv>
implements Model {
    protected final FormulaCreator<TFormulaInfo, TType, TEnv, ?> creator;

    protected AbstractModel(FormulaCreator<TFormulaInfo, TType, TEnv, ?> creator) {
        this.creator = creator;
    }

    @Override
    @Nullable
    public BigInteger evaluate(NumeralFormula.IntegerFormula f) {
        return (BigInteger)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    @Nullable
    public Rational evaluate(NumeralFormula.RationalFormula f) {
        return (Rational)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    @Nullable
    public Boolean evaluate(BooleanFormula f) {
        return (Boolean)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    @Nullable
    public BigInteger evaluate(BitvectorFormula f) {
        return (BigInteger)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    @Nullable
    public final Object evaluate(Formula f) {
        Preconditions.checkArgument((!(f instanceof ArrayFormula) ? 1 : 0) != 0, (Object)"cannot compute a simple constant evaluation for an array-formula");
        return this.evaluateImpl(this.creator.extractInfo(f));
    }

    protected abstract Object evaluateImpl(TFormulaInfo var1);

    @Override
    public String toString() {
        return Joiner.on((char)'\n').join(this.iterator());
    }

    public static abstract class CachingAbstractModel<TFormulaInfo, TType, TEnv>
    extends AbstractModel<TFormulaInfo, TType, TEnv> {
        @Nullable
        private ImmutableList<Model.ValueAssignment> modelAssignments = null;

        protected CachingAbstractModel(FormulaCreator<TFormulaInfo, TType, TEnv, ?> pCreator) {
            super(pCreator);
        }

        @Override
        public final Iterator<Model.ValueAssignment> iterator() {
            if (this.modelAssignments == null) {
                this.modelAssignments = this.modelToList();
            }
            return this.modelAssignments.iterator();
        }

        protected abstract ImmutableList<Model.ValueAssignment> modelToList();
    }
}

