/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import java.util.List;
import org.sosy_lab.solver.backends.z3.Z3FormulaCreator;
import org.sosy_lab.solver.basicimpl.AbstractUFManager;

class Z3UFManager
extends AbstractUFManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3UFManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long createUninterpretedFunctionCallImpl(Long funcDecl, List<Long> pArgs) {
        return Native.mkApp((long)this.z3context, (long)funcDecl, (int)pArgs.size(), (long[])Longs.toArray(pArgs));
    }

    @Override
    protected Long declareUninterpretedFunctionImpl(String pName, Long returnType, List<Long> pArgTypes) {
        long symbol = Native.mkStringSymbol((long)this.z3context, (String)pName);
        long[] sorts = Longs.toArray(pArgTypes);
        long func = Native.mkFuncDecl((long)this.z3context, (long)symbol, (int)sorts.length, (long[])sorts, (long)returnType);
        Native.incRef((long)this.z3context, (long)func);
        return func;
    }
}

