/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.backends.z3.Z3FormulaCreator;
import org.sosy_lab.solver.backends.z3.Z3FormulaManager;
import org.sosy_lab.solver.backends.z3.Z3SolverBasedProver;
import org.sosy_lab.solver.basicimpl.LongArrayBackedList;

class Z3TheoremProver
extends Z3SolverBasedProver<Void>
implements ProverEnvironment {
    private final UniqueIdGenerator trackId = new UniqueIdGenerator();
    private final FormulaManager mgr;
    private static final String UNSAT_CORE_TEMP_VARNAME = "Z3_UNSAT_CORE_%d";
    @Nullable
    private final Map<String, BooleanFormula> storedConstraints;

    Z3TheoremProver(Z3FormulaCreator creator, Z3FormulaManager pMgr, long z3params, Set<SolverContext.ProverOptions> opts) {
        super(creator, z3params);
        this.mgr = pMgr;
        this.storedConstraints = opts.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) ? new HashMap<String, BooleanFormula>() : null;
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.storedConstraints != null) {
            long e = Z3FormulaManager.getZ3Expr(f);
            Native.incRef((long)this.z3context, (long)e);
            String varName = String.format(UNSAT_CORE_TEMP_VARNAME, this.trackId.getFreshId());
            BooleanFormula t = this.mgr.getBooleanFormulaManager().makeVariable(varName);
            Native.solverAssertAndTrack((long)this.z3context, (long)this.z3solver, (long)e, (long)this.creator.extractInfo(t));
            this.storedConstraints.put(varName, f);
            Native.decRef((long)this.z3context, (long)e);
        } else {
            super.addConstraint0(f);
        }
        return null;
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        if (!this.isUnsatWithAssumptions(assumptions)) {
            return Optional.empty();
        }
        ArrayList<BooleanFormula> core = new ArrayList<BooleanFormula>();
        long unsatCore = Native.solverGetUnsatCore((long)this.z3context, (long)this.z3solver);
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            core.add(this.creator.encapsulateBoolean(ast));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return Optional.of(core);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.storedConstraints == null) {
            throw new UnsupportedOperationException("Option to generate the UNSAT core wasn't enabled when creating the prover environment.");
        }
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        long unsatCore = Native.solverGetUnsatCore((long)this.z3context, (long)this.z3solver);
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            Native.incRef((long)this.z3context, (long)ast);
            String varName = Native.astToString((long)this.z3context, (long)ast);
            Native.decRef((long)this.z3context, (long)ast);
            constraints.add(this.storedConstraints.get(varName));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return constraints;
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long[] importantFormulas = new long[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            importantFormulas[i++] = Z3FormulaManager.getZ3Expr(impF);
        }
        try {
            Native.solverPush((long)this.z3context, (long)this.z3solver);
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        while (!this.isUnsat()) {
            long[] valuesOfModel = new long[importantFormulas.length];
            long z3model = Native.solverGetModel((long)this.z3context, (long)this.z3solver);
            for (int j = 0; j < importantFormulas.length; ++j) {
                long funcDecl = Native.getAppDecl((long)this.z3context, (long)importantFormulas[j]);
                long valueOfExpr = Native.modelGetConstInterp((long)this.z3context, (long)z3model, (long)funcDecl);
                if (valueOfExpr == 0L) {
                    this.creator.shutdownNotifier.shutdownIfNecessary();
                    throw new VerifyException("Z3 claims that the value of " + Native.astToString((long)this.z3context, (long)importantFormulas[j]) + " does not matter in allSat call.");
                }
                if (Z3FormulaCreator.isOP(this.z3context, valueOfExpr, Z3_decl_kind.Z3_OP_FALSE.toInt())) {
                    valuesOfModel[j] = Native.mkNot((long)this.z3context, (long)importantFormulas[j]);
                    Native.incRef((long)this.z3context, (long)valuesOfModel[j]);
                    continue;
                }
                valuesOfModel[j] = importantFormulas[j];
            }
            callback.apply((List<BooleanFormula>)new LongArrayBackedList<BooleanFormula>(valuesOfModel){

                @Override
                protected BooleanFormula convert(long pE) {
                    return Z3TheoremProver.this.creator.encapsulateBoolean(pE);
                }
            });
            long negatedModel = Native.mkNot((long)this.z3context, (long)Native.mkAnd((long)this.z3context, (int)valuesOfModel.length, (long[])valuesOfModel));
            Native.incRef((long)this.z3context, (long)negatedModel);
            Native.solverAssert((long)this.z3context, (long)this.z3solver, (long)negatedModel);
        }
        Native.solverPop((long)this.z3context, (long)this.z3solver, (int)1);
        return callback.getResult();
    }
}

