/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import java.util.List;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.backends.z3.Z3FormulaCreator;
import org.sosy_lab.solver.basicimpl.AbstractQuantifiedFormulaManager;

class Z3QuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<Long, Long, Long, Long> {
    private final long z3context;
    private final Z3FormulaCreator z3FormulaCreator;

    Z3QuantifiedFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
        this.z3FormulaCreator = creator;
    }

    @Override
    public Long mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<Long> pVariables, Long pBody) {
        if (pVariables.size() == 0) {
            throw new IllegalArgumentException("List of quantified variables can not be empty");
        }
        return Native.mkQuantifierConst((long)this.z3context, (q == QuantifiedFormulaManager.Quantifier.FORALL ? 1 : 0) != 0, (int)0, (int)pVariables.size(), (long[])Longs.toArray(pVariables), (int)0, (long[])new long[0], (long)pBody);
    }

    @Override
    protected Long eliminateQuantifiers(Long pExtractInfo) throws SolverException, InterruptedException {
        return this.z3FormulaCreator.applyTactics(this.z3context, pExtractInfo, "qe-light", "qe");
    }
}

