/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.RationalFormulaManager;
import org.sosy_lab.solver.backends.z3.Z3AbstractProver;
import org.sosy_lab.solver.backends.z3.Z3Formula;
import org.sosy_lab.solver.backends.z3.Z3FormulaCreator;

class Z3OptimizationProver
extends Z3AbstractProver<Void>
implements OptimizationProverEnvironment {
    private final FormulaManager mgr;
    private final RationalFormulaManager rfmgr;
    private final LogManager logger;
    private static final String Z3_INFINITY_REPRESENTATION = "oo";
    private final long z3optContext;

    Z3OptimizationProver(FormulaManager mgr, Z3FormulaCreator creator, LogManager pLogger) {
        super(creator);
        this.mgr = mgr;
        this.rfmgr = mgr.getRationalFormulaManager();
        this.z3optContext = Native.mkOptimize((long)this.z3context);
        Native.optimizeIncRef((long)this.z3context, (long)this.z3optContext);
        this.logger = pLogger;
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long z3Constraint = this.creator.extractInfo(constraint);
        Native.optimizeAssert((long)this.z3context, (long)this.z3optContext, (long)z3Constraint);
        return null;
    }

    @Override
    public int maximize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3Formula z3Objective = (Z3Formula)objective;
        return Native.optimizeMaximize((long)this.z3context, (long)this.z3optContext, (long)z3Objective.getFormulaInfo());
    }

    @Override
    public int minimize(Formula objective) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Z3Formula z3Objective = (Z3Formula)objective;
        return Native.optimizeMinimize((long)this.z3context, (long)this.z3optContext, (long)z3Objective.getFormulaInfo());
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        int status;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            status = Native.optimizeCheck((long)this.z3context, (long)this.z3optContext);
        }
        catch (Z3Exception ex) {
            throw this.creator.handleZ3Exception(ex);
        }
        if (status == Z3_lbool.Z3_L_FALSE.toInt()) {
            return OptimizationProverEnvironment.OptStatus.UNSAT;
        }
        if (status == Z3_lbool.Z3_L_UNDEF.toInt()) {
            this.creator.shutdownNotifier.shutdownIfNecessary();
            this.logger.log(Level.INFO, new Object[]{"Solver returned an unknown status, explanation: ", Native.optimizeGetReasonUnknown((long)this.z3context, (long)this.z3optContext)});
            return OptimizationProverEnvironment.OptStatus.UNDEF;
        }
        return OptimizationProverEnvironment.OptStatus.OPT;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Native.optimizePush((long)this.z3context, (long)this.z3optContext);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Native.optimizePop((long)this.z3context, (long)this.z3optContext);
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.check() == OptimizationProverEnvironment.OptStatus.UNSAT;
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long ast = Native.optimizeGetUpper((long)this.z3context, (long)this.z3optContext, (int)handle);
        if (this.isInfinity(ast)) {
            return Optional.empty();
        }
        return Optional.of(this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long ast = Native.optimizeGetLower((long)this.z3context, (long)this.z3optContext, (int)handle);
        if (this.isInfinity(ast)) {
            return Optional.empty();
        }
        return Optional.of(this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    protected long getZ3Model() {
        return Native.optimizeGetModel((long)this.z3context, (long)this.z3optContext);
    }

    void setParam(String key, String value) {
        long keySymbol = Native.mkStringSymbol((long)this.z3context, (String)key);
        long valueSymbol = Native.mkStringSymbol((long)this.z3context, (String)value);
        long params = Native.mkParams((long)this.z3context);
        Native.paramsSetSymbol((long)this.z3context, (long)params, (long)keySymbol, (long)valueSymbol);
        Native.optimizeSetParams((long)this.z3context, (long)this.z3optContext, (long)params);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Native.optimizeDecRef((long)this.z3context, (long)this.z3optContext);
        this.closed = true;
    }

    private boolean isInfinity(long ast) {
        return Native.astToString((long)this.z3context, (long)ast).contains(Z3_INFINITY_REPRESENTATION);
    }

    private long replaceEpsilon(long ast, Rational newValue) {
        NumeralFormula.RationalFormula z = this.creator.encapsulate(FormulaType.RationalType, ast);
        Object epsFormula = this.rfmgr.makeVariable("epsilon");
        NumeralFormula.RationalFormula out = this.mgr.substitute(z, (Map<? extends Formula, ? extends Formula>)ImmutableMap.of(epsFormula, (Object)((NumeralFormula.RationalFormula)this.rfmgr.makeNumber(newValue))));
        return Native.simplify((long)this.z3context, (long)this.creator.extractInfo(out));
    }

    private Rational rationalFromZ3AST(long ast) {
        return Rational.ofString((String)Native.getNumeralString((long)this.z3context, (long)ast));
    }

    public String toString() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Native.optimizeToString((long)this.z3context, (long)this.z3optContext);
    }
}

