/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.microsoft.z3.Native;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.backends.z3.Z3FormulaCreator;
import org.sosy_lab.solver.basicimpl.AbstractModel;

class Z3Model
extends AbstractModel.CachingAbstractModel<Long, Long, Long> {
    private final long model;
    private final long z3context;
    private static final Pattern Z3_IRRELEVANT_MODEL_TERM_PATTERN = Pattern.compile(".*![0-9]+");
    private final Z3FormulaCreator creator;

    private Z3Model(long z3context, long z3model, Z3FormulaCreator pCreator) {
        super(pCreator);
        Native.modelIncRef((long)z3context, (long)z3model);
        this.model = z3model;
        this.z3context = z3context;
        this.creator = pCreator;
    }

    static Z3Model create(long z3context, long z3model, Z3FormulaCreator pCreator) {
        return new Z3Model(z3context, z3model, pCreator);
    }

    @Override
    @Nullable
    public Object evaluateImpl(Long f) {
        Native.LongPtr out = new Native.LongPtr();
        boolean status = Native.modelEval((long)this.z3context, (long)this.model, (long)f, (boolean)false, (Native.LongPtr)out);
        Verify.verify((boolean)status, (String)"Error during model evaluation", (Object[])new Object[0]);
        long outValue = out.value;
        if (this.creator.isConstant(outValue)) {
            return this.creator.convertValue(outValue);
        }
        return null;
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> modelToList() {
        ImmutableList.Builder out = ImmutableList.builder();
        for (int constIdx = 0; constIdx < Native.modelGetNumConsts((long)this.z3context, (long)this.model); ++constIdx) {
            long keyDecl = Native.modelGetConstDecl((long)this.z3context, (long)this.model, (int)constIdx);
            Native.incRef((long)this.z3context, (long)keyDecl);
            out.addAll(this.getConstAssignments(keyDecl));
            Native.decRef((long)this.z3context, (long)keyDecl);
        }
        for (int funcIdx = 0; funcIdx < Native.modelGetNumFuncs((long)this.z3context, (long)this.model); ++funcIdx) {
            long funcDecl = Native.modelGetFuncDecl((long)this.z3context, (long)this.model, (int)funcIdx);
            Native.incRef((long)this.z3context, (long)funcDecl);
            if (!this.isInternalSymbol(funcDecl)) {
                String functionName = this.creator.symbolToString(Native.getDeclName((long)this.z3context, (long)funcDecl));
                out.addAll(this.getFunctionAssignments(funcDecl, funcDecl, functionName));
            }
            Native.decRef((long)this.z3context, (long)funcDecl);
        }
        return out.build();
    }

    private boolean isInternalSymbol(long funcDecl) {
        return Z3_IRRELEVANT_MODEL_TERM_PATTERN.matcher(this.creator.symbolToString(Native.getDeclName((long)this.z3context, (long)funcDecl))).matches();
    }

    private Collection<Model.ValueAssignment> getConstAssignments(long keyDecl) {
        Preconditions.checkArgument((Native.getArity((long)this.z3context, (long)keyDecl) == 0 ? 1 : 0) != 0, (Object)"Declaration is not a constant");
        long var = Native.mkApp((long)this.z3context, (long)keyDecl, (int)0, (long[])new long[0]);
        Formula key = this.creator.encapsulateWithTypeOf(var);
        long value = Native.modelGetConstInterp((long)this.z3context, (long)this.model, (long)keyDecl);
        this.checkReturnValue(value, keyDecl);
        Native.incRef((long)this.z3context, (long)value);
        try {
            long symbol = Native.getDeclName((long)this.z3context, (long)keyDecl);
            if (this.creator.isConstant(value)) {
                List<Model.ValueAssignment> list = Collections.singletonList(new Model.ValueAssignment(key, this.creator.symbolToString(symbol), this.creator.convertValue(value), (Collection<?>)ImmutableList.of()));
                return list;
            }
            if (Native.isAsArray((long)this.z3context, (long)value)) {
                long arrayFormula = Native.mkConst((long)this.z3context, (long)symbol, (long)Native.getSort((long)this.z3context, (long)value));
                Native.incRef((long)this.z3context, (long)arrayFormula);
                Collection<Model.ValueAssignment> collection = this.getArrayAssignments(symbol, arrayFormula, value, Collections.emptyList());
                return collection;
            }
            throw new UnsupportedOperationException("unknown model evaluation: " + Native.astToString((long)this.z3context, (long)value));
        }
        finally {
            Native.decRef((long)this.z3context, (long)value);
        }
    }

    private Collection<Model.ValueAssignment> getArrayAssignments(long arraySymbol, long arrayFormula, long value, List<Object> upperIndices) {
        long evalDecl = Native.getAsArrayFuncDecl((long)this.z3context, (long)value);
        Native.incRef((long)this.z3context, (long)evalDecl);
        long interp = Native.modelGetFuncInterp((long)this.z3context, (long)this.model, (long)evalDecl);
        this.checkReturnValue(interp, evalDecl);
        Native.funcInterpIncRef((long)this.z3context, (long)interp);
        ArrayList<Model.ValueAssignment> lst = new ArrayList<Model.ValueAssignment>();
        int numInterpretations = Native.funcInterpGetNumEntries((long)this.z3context, (long)interp);
        for (int interpIdx = 0; interpIdx < numInterpretations; ++interpIdx) {
            long entry = Native.funcInterpGetEntry((long)this.z3context, (long)interp, (int)interpIdx);
            Native.funcEntryIncRef((long)this.z3context, (long)entry);
            long arrayValue = Native.funcEntryGetValue((long)this.z3context, (long)entry);
            Native.incRef((long)this.z3context, (long)arrayValue);
            int noArgs = Native.funcEntryGetNumArgs((long)this.z3context, (long)entry);
            assert (noArgs == 1) : "array modelled as UF is expected to have only one parameter, aka index";
            long arrayIndex = Native.funcEntryGetArg((long)this.z3context, (long)entry, (int)0);
            Native.incRef((long)this.z3context, (long)arrayIndex);
            long select = Native.mkSelect((long)this.z3context, (long)arrayFormula, (long)arrayIndex);
            Native.incRef((long)this.z3context, (long)select);
            ArrayList innerIndices = Lists.newArrayList(upperIndices);
            innerIndices.add(this.evaluateImpl(arrayIndex));
            if (this.creator.isConstant(arrayValue)) {
                lst.add(new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.symbolToString(arraySymbol), this.creator.convertValue(arrayValue), innerIndices));
            } else if (Native.isAsArray((long)this.z3context, (long)arrayValue)) {
                lst.addAll(this.getArrayAssignments(arraySymbol, select, arrayValue, innerIndices));
            }
            Native.decRef((long)this.z3context, (long)arrayIndex);
            Native.funcEntryDecRef((long)this.z3context, (long)entry);
        }
        Native.funcInterpDecRef((long)this.z3context, (long)interp);
        Native.decRef((long)this.z3context, (long)evalDecl);
        return lst;
    }

    private void checkReturnValue(long value, long funcDecl) {
        if (value == 0L) {
            throw new VerifyException("Z3 unexpectedly claims that the value of " + Native.funcDeclToString((long)this.z3context, (long)funcDecl) + " does not matter in model.");
        }
    }

    private Collection<Model.ValueAssignment> getFunctionAssignments(long evalDecl, long funcDecl, String functionName) {
        long interp = Native.modelGetFuncInterp((long)this.z3context, (long)this.model, (long)evalDecl);
        this.checkReturnValue(interp, evalDecl);
        Native.funcInterpIncRef((long)this.z3context, (long)interp);
        ArrayList<Model.ValueAssignment> lst = new ArrayList<Model.ValueAssignment>();
        int numInterpretations = Native.funcInterpGetNumEntries((long)this.z3context, (long)interp);
        if (numInterpretations == 0) {
            long elseInterp = Native.funcInterpGetElse((long)this.z3context, (long)interp);
            Native.incRef((long)this.z3context, (long)elseInterp);
            long aliasDecl = Native.getAppDecl((long)this.z3context, (long)elseInterp);
            Native.incRef((long)this.z3context, (long)aliasDecl);
            if (this.isInternalSymbol(aliasDecl)) {
                lst.addAll(this.getFunctionAssignments(aliasDecl, funcDecl, functionName));
            }
            Native.decRef((long)this.z3context, (long)aliasDecl);
            Native.decRef((long)this.z3context, (long)elseInterp);
        } else {
            for (int interpIdx = 0; interpIdx < numInterpretations; ++interpIdx) {
                long entry = Native.funcInterpGetEntry((long)this.z3context, (long)interp, (int)interpIdx);
                Native.funcEntryIncRef((long)this.z3context, (long)entry);
                long entryValue = Native.funcEntryGetValue((long)this.z3context, (long)entry);
                if (this.creator.isConstant(entryValue)) {
                    lst.add(this.getFunctionAssignment(functionName, funcDecl, entry, entryValue));
                }
                Native.funcEntryDecRef((long)this.z3context, (long)entry);
            }
        }
        Native.funcInterpDecRef((long)this.z3context, (long)interp);
        return lst;
    }

    private Model.ValueAssignment getFunctionAssignment(String functionName, long funcDecl, long entry, long entryValue) {
        Object value = this.creator.convertValue(entryValue);
        int noArgs = Native.funcEntryGetNumArgs((long)this.z3context, (long)entry);
        long[] args = new long[noArgs];
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (int k = 0; k < noArgs; ++k) {
            long arg = Native.funcEntryGetArg((long)this.z3context, (long)entry, (int)k);
            Native.incRef((long)this.z3context, (long)arg);
            argumentInterpretation.add(this.creator.convertValue(arg));
            args[k] = arg;
        }
        Formula formula = this.creator.encapsulateWithTypeOf(Native.mkApp((long)this.z3context, (long)funcDecl, (int)args.length, (long[])args));
        for (long arg : args) {
            Native.decRef((long)this.z3context, (long)arg);
        }
        return new Model.ValueAssignment(formula, functionName, value, argumentInterpretation);
    }

    @Override
    public String toString() {
        return Native.modelToString((long)this.z3context, (long)this.model);
    }

    @Override
    public void close() {
        Native.modelDecRef((long)this.z3context, (long)this.model);
    }
}

