/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.base.Preconditions;
import com.microsoft.z3.Native;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;

abstract class Z3Formula
implements Formula {
    private final long z3expr;
    private final long z3context;

    private Z3Formula(long z3context, long z3expr) {
        Preconditions.checkArgument((z3context != 0L ? 1 : 0) != 0, (Object)"Z3 context is null");
        Preconditions.checkArgument((z3expr != 0L ? 1 : 0) != 0, (Object)"Z3 formula is null");
        this.z3expr = z3expr;
        this.z3context = z3context;
        Native.incRef((long)z3context, (long)z3expr);
    }

    public final String toString() {
        return Native.astToString((long)this.z3context, (long)this.z3expr);
    }

    public final boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof Z3Formula)) {
            return false;
        }
        Z3Formula other = (Z3Formula)obj;
        return this.z3context == other.z3context && Native.isEqAst((long)this.z3context, (long)this.z3expr, (long)other.z3expr);
    }

    public final int hashCode() {
        return Native.getAstId((long)this.z3context, (long)this.z3expr);
    }

    final long getFormulaInfo() {
        return this.z3expr;
    }

    static final class Z3BooleanFormula
    extends Z3Formula
    implements BooleanFormula {
        Z3BooleanFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3RationalFormula
    extends Z3Formula
    implements NumeralFormula.RationalFormula {
        Z3RationalFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3IntegerFormula
    extends Z3Formula
    implements NumeralFormula.IntegerFormula {
        Z3IntegerFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3FloatingPointRoundingModeFormula
    extends Z3Formula
    implements FloatingPointRoundingModeFormula {
        Z3FloatingPointRoundingModeFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3FloatingPointFormula
    extends Z3Formula
    implements FloatingPointFormula {
        Z3FloatingPointFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3BitvectorFormula
    extends Z3Formula
    implements BitvectorFormula {
        Z3BitvectorFormula(long z3context, long z3expr) {
            super(z3context, z3expr);
        }
    }

    static final class Z3ArrayFormula<TI extends Formula, TE extends Formula>
    extends Z3Formula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        Z3ArrayFormula(long pZ3context, long pZ3expr, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pZ3context, pZ3expr);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

