/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.collect.ImmutableList;
import com.microsoft.z3.Native;
import java.math.BigDecimal;
import java.util.List;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.backends.z3.Z3FormulaCreator;
import org.sosy_lab.solver.backends.z3.Z3UFManager;
import org.sosy_lab.solver.basicimpl.AbstractFloatingPointFormulaManager;

class Z3FloatingPointFormulaManager
extends AbstractFloatingPointFormulaManager<Long, Long, Long, Long> {
    private static final FormulaType.FloatingPointType highPrec = FormulaType.getFloatingPointType(15, 112);
    private final Z3UFManager ufmgr;
    private final long z3context;
    private final long roundingMode;

    Z3FloatingPointFormulaManager(Z3FormulaCreator creator, Z3UFManager pUFMgr) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
        this.ufmgr = pUFMgr;
        this.roundingMode = Native.mkFpaRoundNearestTiesToEven((long)this.z3context);
        Native.incRef((long)this.z3context, (long)this.roundingMode);
    }

    private long mkFpaSort(FormulaType.FloatingPointType pType) {
        return (Long)this.getFormulaCreator().getFloatingPointType(pType);
    }

    @Override
    public Long makeNumberImpl(double pN, FormulaType.FloatingPointType pType) {
        if (Double.isNaN(pN) || Double.isInfinite(pN)) {
            return Native.mkFpaNumeralDouble((long)this.z3context, (double)pN, (long)this.mkFpaSort(pType));
        }
        return this.makeNumberImpl(Double.toString(pN), pType);
    }

    @Override
    public Long makeNumberImpl(BigDecimal pN, FormulaType.FloatingPointType pType) {
        return this.makeNumberImpl(pN.toPlainString(), pType);
    }

    @Override
    protected Long makeNumberImpl(String pN, FormulaType.FloatingPointType pType) {
        if (pType.getExponentSize() <= highPrec.getExponentSize() || pType.getMantissaSize() <= highPrec.getMantissaSize()) {
            long highPrecNumber = Native.mkNumeral((long)this.z3context, (String)pN, (long)this.mkFpaSort(highPrec));
            Native.incRef((long)this.z3context, (long)highPrecNumber);
            long smallPrecNumber = this.castToImpl(highPrecNumber, (FormulaType<?>)pType);
            Native.incRef((long)this.z3context, (long)smallPrecNumber);
            long result = Native.simplify((long)this.z3context, (long)smallPrecNumber);
            Native.decRef((long)this.z3context, (long)highPrecNumber);
            Native.decRef((long)this.z3context, (long)smallPrecNumber);
            return result;
        }
        return Native.mkNumeral((long)this.z3context, (String)pN, (long)this.mkFpaSort(pType));
    }

    @Override
    public Long makeVariableImpl(String var, FormulaType.FloatingPointType pType) {
        return (Long)this.getFormulaCreator().makeVariable(this.mkFpaSort(pType), var);
    }

    @Override
    protected Long makePlusInfinityImpl(FormulaType.FloatingPointType pType) {
        return Native.mkFpaInf((long)this.z3context, (long)this.mkFpaSort(pType), (boolean)false);
    }

    @Override
    protected Long makeMinusInfinityImpl(FormulaType.FloatingPointType pType) {
        return Native.mkFpaInf((long)this.z3context, (long)this.mkFpaSort(pType), (boolean)true);
    }

    @Override
    protected Long makeNaNImpl(FormulaType.FloatingPointType pType) {
        return Native.mkFpaNan((long)this.z3context, (long)this.mkFpaSort(pType));
    }

    @Override
    protected Long castToImpl(Long pNumber, FormulaType<?> pTargetType) {
        if (pTargetType.isFloatingPointType()) {
            FormulaType.FloatingPointType targetType = (FormulaType.FloatingPointType)pTargetType;
            return Native.mkFpaToFpFloat((long)this.z3context, (long)this.roundingMode, (long)pNumber, (long)this.mkFpaSort(targetType));
        }
        if (pTargetType.isBitvectorType()) {
            FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)pTargetType;
            return Native.mkFpaToSbv((long)this.z3context, (long)this.roundingMode, (long)pNumber, (int)targetType.getSize());
        }
        if (pTargetType.isRationalType()) {
            return Native.mkFpaToReal((long)this.z3context, (long)pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    @Override
    protected Long castFromImpl(Long pNumber, boolean signed, FormulaType.FloatingPointType pTargetType) {
        FormulaType<?> formulaType = this.getFormulaCreator().getFormulaType(pNumber);
        if (formulaType.isFloatingPointType()) {
            return this.castToImpl(pNumber, (FormulaType<?>)pTargetType);
        }
        if (formulaType.isBitvectorType()) {
            if (signed) {
                return Native.mkFpaToFpSigned((long)this.z3context, (long)this.roundingMode, (long)pNumber, (long)this.mkFpaSort(pTargetType));
            }
            return Native.mkFpaToFpUnsigned((long)this.z3context, (long)this.roundingMode, (long)pNumber, (long)this.mkFpaSort(pTargetType));
        }
        if (formulaType.isRationalType()) {
            return Native.mkFpaToFpReal((long)this.z3context, (long)this.roundingMode, (long)pNumber, (long)this.mkFpaSort(pTargetType));
        }
        return this.genericCast(pNumber, pTargetType);
    }

    private Long genericCast(Long pNumber, FormulaType<?> pTargetType) {
        FormulaType<?> argType = this.getFormulaCreator().getFormulaType(pNumber);
        long castFuncDecl = this.ufmgr.declareUninterpretedFunctionImpl("__cast_" + argType + "_to_" + pTargetType, (Long)this.toSolverType(pTargetType), (List<Long>)ImmutableList.of((Object)((Long)this.toSolverType(argType))));
        return Native.mkApp((long)this.z3context, (long)castFuncDecl, (int)1, (long[])new long[]{pNumber});
    }

    @Override
    public Long negate(Long pNumber) {
        return Native.mkFpaNeg((long)this.z3context, (long)pNumber);
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Native.mkFpaAdd((long)this.z3context, (long)this.roundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Native.mkFpaSub((long)this.z3context, (long)this.roundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Native.mkFpaMul((long)this.z3context, (long)this.roundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long divide(Long pNumber1, Long pNumber2) {
        return Native.mkFpaDiv((long)this.z3context, (long)this.roundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long assignment(Long pNumber1, Long pNumber2) {
        return Native.mkEq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long equalWithFPSemantics(Long pNumber1, Long pNumber2) {
        return Native.mkFpaEq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2) {
        return Native.mkFpaGt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkFpaGeq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2) {
        return Native.mkFpaLt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkFpaLeq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long isNaN(Long pParam) {
        return Native.mkFpaIsNan((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isInfinity(Long pParam) {
        return Native.mkFpaIsInfinite((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isZero(Long pParam) {
        return Native.mkFpaIsZero((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isSubnormal(Long pParam) {
        return Native.mkFpaIsSubnormal((long)this.z3context, (long)pParam);
    }
}

