/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.z3;

import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import java.util.Collection;
import org.sosy_lab.solver.backends.z3.Z3FormulaCreator;
import org.sosy_lab.solver.basicimpl.AbstractBooleanFormulaManager;

class Z3BooleanFormulaManager
extends AbstractBooleanFormulaManager<Long, Long, Long, Long> {
    private final long z3context;

    Z3BooleanFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = (Long)this.getFormulaCreator().getBoolType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Long makeBooleanImpl(boolean pValue) {
        if (pValue) {
            return Native.mkTrue((long)this.z3context);
        }
        return Native.mkFalse((long)this.z3context);
    }

    @Override
    protected Long not(Long pParam) {
        return Native.mkNot((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long and(Long pParam1, Long pParam2) {
        return Native.mkAnd((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long or(Long pParam1, Long pParam2) {
        return Native.mkOr((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long orImpl(Collection<Long> params) {
        return Native.mkOr((long)this.z3context, (int)params.size(), (long[])Longs.toArray(params));
    }

    @Override
    protected Long andImpl(Collection<Long> params) {
        return Native.mkAnd((long)this.z3context, (int)params.size(), (long[])Longs.toArray(params));
    }

    @Override
    protected Long xor(Long pParam1, Long pParam2) {
        return Native.mkXor((long)this.z3context, (long)pParam1, (long)pParam2);
    }

    @Override
    protected Long equivalence(Long pBits1, Long pBits2) {
        return Native.mkEq((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    protected Long implication(Long pBits1, Long pBits2) {
        return Native.mkImplies((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    protected boolean isTrue(Long pParam) {
        return Z3FormulaCreator.isOP(this.z3context, pParam, Z3_decl_kind.Z3_OP_TRUE.toInt());
    }

    @Override
    protected boolean isFalse(Long pParam) {
        return Z3FormulaCreator.isOP(this.z3context, pParam, Z3_decl_kind.Z3_OP_FALSE.toInt());
    }

    @Override
    protected Long ifThenElse(Long pCond, Long pF1, Long pF2) {
        return Native.mkIte((long)this.z3context, (long)pCond, (long)pF1, (long)pF2);
    }
}

