/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.backends.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.backends.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.solver.basicimpl.AbstractNumeralFormulaManager;

abstract class SmtInterpolNumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Term, Sort, SmtInterpolEnvironment, ParamFormulaType, ResultFormulaType, FunctionSymbol> {
    private final SmtInterpolEnvironment env;
    private final SmtInterpolFormulaCreator creator;

    SmtInterpolNumeralFormulaManager(SmtInterpolFormulaCreator pCreator) {
        super(pCreator);
        this.creator = pCreator;
        this.env = (SmtInterpolEnvironment)pCreator.getEnv();
    }

    @Override
    protected boolean isNumeral(Term val) {
        return this.creator.isNumber(val);
    }

    @Override
    public Term negate(Term pNumber) {
        return this.env.term("*", this.env.numeral("-1"), pNumber);
    }

    @Override
    public Term add(Term pNumber1, Term pNumber2) {
        return this.env.term("+", pNumber1, pNumber2);
    }

    @Override
    public Term subtract(Term pNumber1, Term pNumber2) {
        return this.env.term("-", pNumber1, pNumber2);
    }

    @Override
    public Term multiply(Term pNumber1, Term pNumber2) {
        if (this.isNumeral(pNumber1) || this.isNumeral(pNumber2)) {
            return this.env.term("*", pNumber1, pNumber2);
        }
        return super.multiply(pNumber1, pNumber2);
    }

    @Override
    protected Term modularCongruence(Term pNumber1, Term pNumber2, long pModulo) {
        Sort intSort = pNumber1.getTheory().getNumericSort();
        if (pModulo > 0L && intSort.equals(pNumber1.getSort()) && intSort.equals(pNumber2.getSort())) {
            Term n = this.env.numeral(BigInteger.valueOf(pModulo));
            Term x = this.subtract(pNumber1, pNumber2);
            return this.env.term("=", x, this.env.term("*", n, this.env.term("div", x, n)));
        }
        return this.env.getTheory().mTrue;
    }

    @Override
    public Term equal(Term pNumber1, Term pNumber2) {
        return this.env.term("=", pNumber1, pNumber2);
    }

    @Override
    public Term greaterThan(Term pNumber1, Term pNumber2) {
        return this.env.term(">", pNumber1, pNumber2);
    }

    @Override
    public Term greaterOrEquals(Term pNumber1, Term pNumber2) {
        return this.env.term(">=", pNumber1, pNumber2);
    }

    @Override
    public Term lessThan(Term pNumber1, Term pNumber2) {
        return this.env.term("<", pNumber1, pNumber2);
    }

    @Override
    public Term lessOrEquals(Term pNumber1, Term pNumber2) {
        return this.env.term("<=", pNumber1, pNumber2);
    }
}

