/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.backends.smtinterpol.SmtInterpolBasicProver;
import org.sosy_lab.solver.backends.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.backends.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractBooleanFormulaManager;

class SmtInterpolInterpolatingProver
extends SmtInterpolBasicProver<String, String>
implements InterpolatingProverEnvironment<String> {
    private final SmtInterpolFormulaManager mgr;
    private final SmtInterpolEnvironment env;
    private final Map<String, Term> annotatedTerms;

    SmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr) {
        super(pMgr);
        this.mgr = pMgr;
        this.env = this.mgr.createEnvironment();
        this.annotatedTerms = new HashMap<String, Term>();
    }

    @Override
    public void pop() {
        for (String removed : (List)this.assertedFormulas.peek()) {
            this.annotatedTerms.remove(removed);
        }
        super.pop();
    }

    @Override
    public String addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        String termName = SmtInterpolInterpolatingProver.generateTermName();
        Term t = (Term)this.mgr.extractInfo(f);
        Term annotatedTerm = this.env.annotate(t, new Annotation(":named", (Object)termName));
        this.env.assertTerm(annotatedTerm);
        ((List)this.assertedFormulas.peek()).add(termName);
        this.annotatedTerms.put(termName, t);
        return termName;
    }

    @Override
    public BooleanFormula getInterpolant(List<String> pTermNamesOfA) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        if (pTermNamesOfA.isEmpty()) {
            return ((AbstractBooleanFormulaManager)this.mgr.getBooleanFormulaManager()).makeBoolean(true);
        }
        if (pTermNamesOfA.containsAll(this.annotatedTerms.keySet())) {
            return ((AbstractBooleanFormulaManager)this.mgr.getBooleanFormulaManager()).makeBoolean(false);
        }
        HashSet<String> termNamesOfA = new HashSet<String>(pTermNamesOfA);
        Set<String> termNamesOfB = this.annotatedTerms.keySet().stream().filter(n -> !termNamesOfA.contains(n)).collect(Collectors.toSet());
        Term termA = this.buildConjunctionOfNamedTerms(termNamesOfA);
        Term termB = this.buildConjunctionOfNamedTerms(termNamesOfB);
        return this.getInterpolant(termA, termB);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<String>> partitionedTermNames) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        Term[] itps = this.env.getInterpolants(formulas);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        return result;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<String>> partitionedTermNames, int[] startOfSubTree) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        assert (SmtInterpolInterpolatingProver.checkSubTrees(partitionedTermNames, startOfSubTree));
        Term[] itps = this.env.getTreeInterpolants(formulas, startOfSubTree);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        return result;
    }

    private static boolean checkSubTrees(List<Set<String>> partitionedTermNames, int[] startOfSubTree) {
        for (int i = 0; i < partitionedTermNames.size(); ++i) {
            if (startOfSubTree[i] < 0) {
                throw new AssertionError((Object)"subtree array must not contain negative element");
            }
            int j = i;
            while (startOfSubTree[i] < j) {
                j = startOfSubTree[j - 1];
            }
            if (startOfSubTree[i] != j) {
                throw new AssertionError((Object)"malformed subtree array.");
            }
        }
        if (startOfSubTree[partitionedTermNames.size() - 1] != 0) {
            throw new AssertionError((Object)"malformed subtree array.");
        }
        return true;
    }

    protected BooleanFormula getInterpolant(Term termA, Term termB) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term[] itp = this.env.getInterpolants(new Term[]{termA, termB});
        assert (itp.length == 1);
        return this.mgr.encapsulateBooleanFormula(itp[0]);
    }

    private Term buildConjunctionOfNamedTerms(Set<String> termNames) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Preconditions.checkArgument((!termNames.isEmpty() ? 1 : 0) != 0);
        Object[] terms = new Term[termNames.size()];
        int i = 0;
        for (String termName : termNames) {
            terms[i] = this.env.term(termName, new Term[0]);
            ++i;
        }
        if (terms.length > 1) {
            return this.env.term("and", (Term[])terms);
        }
        return (Term)Iterators.getOnlyElement((Iterator)Iterators.forArray((Object[])terms));
    }

    @Override
    public void close() {
        this.assertedFormulas.clear();
        this.annotatedTerms.clear();
        super.close();
    }

    @Override
    protected Collection<Term> getAssertedTerms() {
        return this.annotatedTerms.values();
    }
}

