/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.backends.princess;

import ap.SimpleAPI;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.INot;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.backends.princess.PrincessAbstractProver;
import org.sosy_lab.solver.backends.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.backends.princess.PrincessFormulaManager;
import scala.Option;

class PrincessTheoremProver
extends PrincessAbstractProver<Void, IExpression>
implements ProverEnvironment {
    PrincessTheoremProver(PrincessFormulaManager pMgr, PrincessFormulaCreator creator, SimpleAPI pApi, ShutdownNotifier pShutdownNotifier) {
        super(pMgr, creator, pApi, pShutdownNotifier);
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        IFormula t = (IFormula)this.mgr.extractInfo(constraint);
        ((List)this.assertedFormulas.peek()).add(t);
        this.addConstraint0(t);
        return null;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ArrayList<IFormula> importantFormulas = new ArrayList<IFormula>(important.size());
        for (BooleanFormula impF : important) {
            importantFormulas.add((IFormula)this.mgr.extractInfo(impF));
        }
        this.api.push();
        while (!this.isUnsat()) {
            this.shutdownNotifier.shutdownIfNecessary();
            IBoolLit newFormula = new IBoolLit(true);
            ArrayList<BooleanFormula> wrappedPartialModel = new ArrayList<BooleanFormula>(important.size());
            for (IFormula f : importantFormulas) {
                Option value = this.api.evalPartial(f);
                if (!value.isDefined()) continue;
                boolean isTrueValue = (Boolean)value.get();
                IFormula newElement = isTrueValue ? f : new INot(f);
                wrappedPartialModel.add(this.mgr.encapsulateBooleanFormula((IExpression)newElement));
                newFormula = new IBinFormula(IBinJunctor.And(), (IFormula)newFormula, newElement);
            }
            callback.apply(wrappedPartialModel);
            this.addConstraint0((IFormula)new INot((IFormula)newFormula));
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.api.pop();
        this.wasLastSatCheckSat = false;
        return callback.getResult();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("UNSAT cores not supported by Princess");
    }

    @Override
    protected Collection<? extends IExpression> getAssertedFormulas() {
        ArrayList result = new ArrayList();
        this.assertedFormulas.forEach(result::addAll);
        return result;
    }
}

